local M = {}
M.type = "auxiliary"

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 0
local textureHeight = 0
local textureFPS = 0
local updateTimer = 0
local testfunc = 0

local function updateGFX(dt)
    if electrics.values.wheelspeed == 20 then
        testfunc = true
    else
        testfunc = false
end

local function init(jbeamData)
    screenMaterialName = jbeamData.screenMaterialName or "@helloworld"
    htmlFilePath = jbeamData.htmlFilePath or "local://local/vehicles/acmm5f90/lua/helloworld.html"
    textureWidth = jbeamData.textureWidth or 256
    textureHeight = jbeamData.textureHeight or 128
    textureFPS = jbeamData.textureFPS or 30

    htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
    obj:queueGameEngineLua(string.format("extensions.ui_uinavi.requestVehicleDashboardMap(%q, nil, %d)", screenMaterialName, obj:getID()))
    if jbeamData.bootscreenImage then
      htmlTexture.call(screenMaterialName, "map.setBootscreenImage", {url = jbeamData.bootscreenImage})
    end
end
end

M.init = init
M.reset = nop -- this is needed so that we do not call init when reseting
M.updateGFX = updateGFX

return M