local M = {}

M.hasReachedTargetSOC = false
M.minimumSOC = 20
M.maximumSOC = 80

local max = math.max

local p1 = nil

local targetSOC = 50
local currentRemainingRatio = 0
local state = {}
local hybridType = nil
local hybridMode = nil

local function onReset()
  p1 = powertrain.getDevicesByType("p1_Motor")
  if not p1[1] then
    log("W", "socControl", "P1 not found")
    extensions.unload("socControl")
    return
  end
  hybridType = p1[1].hybridType
  if not hybridType then
    log("W", "socControl", "hybridType not found")
    extensions.unload("socControl")
    return
  end
  hybridMode = p1[1].hybridMode
  M.setMode(hybridMode)
  M.setSOC(p1[1].SOC)
  M.hasReachedTargetSOC = false
  log("D", "socControl", "SOC Control online")
  state = {}
  M.requestState()
end

local function updateGFX(dt)
  if not hybridType then
    return
  end

  currentRemainingRatio = electrics.values.fuel * 100 or 0

  if electrics.values.ignitionLevel == 2 and electrics.values.checkRE == 0 and currentRemainingRatio < 15 and hybridMode == "EV" then
    if hybridType == "REEV" then
      M.setMode("RE")
    elseif hybridType == "iDM" then
      M.setMode("HEV")
    end
  end

  if electrics.values.checkRE == 1 and hybridMode ~= "EV" then
    M.setMode("EV")
  end

  electrics.values.hybridMode = hybridMode

  local currentError = currentRemainingRatio - targetSOC
  M.hasReachedTargetSOC = math.abs(currentError) / targetSOC <= 0.02
  M.requestState()
end

local function setSOC(soc)
  if not hybridType then
    return
  end
  targetSOC = clamp(soc, M.minimumSOC, M.maximumSOC)
  electrics.values.hybridSOC = targetSOC
  M.hasReachedTargetSOC = false
  M.requestState()
end

local function setMode(mode)
  if not hybridType then
    return
  end
  if mode == "EV" then
    if electrics.values.ignitionLevel < 2 or electrics.values.checkRE == 1 or currentRemainingRatio >= 15 then
      hybridMode = "EV"
    end
  elseif mode == "HEV" then
    if hybridType == "iDM" and electrics.values.checkRE == 0 then
      hybridMode = "HEV"
    end
  elseif mode == "RE" then
    if electrics.values.checkRE == 0 then
      hybridMode = "RE"
    end
  end
  M.requestState()
end

local function requestState()
  if not hybridType then
    return
  end
  state.targetSOC = targetSOC
  state.hybridMode = hybridMode

  if not playerInfo.firstPlayerSeated then
    return
  end
  guihooks.trigger("SOC_ControlState", state)
end

local function getConfiguration()
  if not hybridType then
    return
  end
  return {targetSOC = targetSOC, minimumSOC = M.minimumSOC, maximumSOC = M.maximumSOC, hasReachedTargetSOC = M.hasReachedTargetSOC}
end

-- public interface
M.onReset = onReset
M.updateGFX = updateGFX
M.setSOC = setSOC
M.setMode = setMode
M.requestState = requestState
M.getConfiguration = getConfiguration

return M
