local M = {}
M.type = "auxiliary"
M.relevantDevice = "engine"

local abs = math.abs
local min = math.min
local max = math.max
local rpmToAV = 0.104719755

local engine = nil
local p1_Motors = nil
local engageRPM = 1500
local engageAV = engageRPM * rpmToAV
local p1State = 0
local idlingTime = 0
local idlingBreak = 0

local function updateMotorIgnition()
  if electrics.values.ignitionLevel >= 2 then
    for _, motor in ipairs(p1_Motors) do
      motor.ignitionCoef = 1
    end
  elseif electrics.values.ignitionLevel < 2 then
    for _, motor in ipairs(p1_Motors) do
      motor.ignitionCoef = 0
    end
  end
end

local function updateBatteryState()
  local totalCapacity = 0
  local remainingEnergy = 0
  for _, motor in pairs(p1_Motors) do
    for _, s in pairs(motor.registeredEnergyStorages) do
      local storage = energyStorage.getStorage(s)
      if storage then
        totalCapacity = totalCapacity + storage.energyCapacity
        remainingEnergy = remainingEnergy + storage.storedEnergy
      end
    end
  end
  local remainingBatteryRatio = remainingEnergy / totalCapacity
  electrics.values.remainingBatteryRatio = remainingBatteryRatio
end

local function updateEHSState(dt)
  local vehicleController = require("controller/vehicleController/vehicleController")

  local aggression = clamp((vehicleController.drivingAggression - 0.5) / 0.5, 0, 1)
  local aggressionCoef = aggression * aggression

  local function idlingTempKeeper()
    if engine.thermals.coolantTemperature >= 75 and electrics.values.remainingBatteryRatio > 0.25 then
      idlingBreak = 1
    end
    if engine.thermals.coolantTemperature < 70 or electrics.values.remainingBatteryRatio <= 0.25 or electrics.values.gear == "R" then
      idlingBreak = 0
    end
  end

  if electrics.values.ignitionLevel >= 2 then  
    engine:deactivateStarter(engine)
    idlingTempKeeper()
    if input.throttle <= 1e-2 and electrics.values.wheelspeed < 0.25 and string.match(electrics.values.gear, "^S%d+") == nil then
      p1State = 1
      if idlingBreak == 1 then
        idlingTime = idlingTime + dt
        electrics.values.p1Throttle = 0
        electrics.values.p1RegenThrottle = 0
        if idlingTime > 2 then
          engine.ignitionCoef = 0
          electrics.values.p1RegenThrottle = 0
        end
      else
        idlingTime = 0
        engine.ignitionCoef = 1
        electrics.values.p1Throttle = 0
        if electrics.values.remainingBatteryRatio <= 0.25 then
          electrics.values.p1RegenThrottle = 0.25
        else
          electrics.values.p1RegenThrottle = 0
        end
      end
    elseif input.brake > 0 and electrics.values.wheelspeed < 2 and string.match(electrics.values.gear, "^S%d+") == nil then
      p1State = 1
      if idlingBreak == 1 then
        electrics.values.p1Throttle = 0
        electrics.values.p1RegenThrottle = 0
        engine.ignitionCoef = 0
      else
        idlingTime = 0
        engine.ignitionCoef = 1
        electrics.values.p1Throttle = 0
        if electrics.values.remainingBatteryRatio <= 0.25 then
          electrics.values.p1RegenThrottle = 0.25
        else
          electrics.values.p1RegenThrottle = 0
        end
      end
    elseif engine.outputAV1 < engageAV and p1State == 1 then
      idlingTime = 0
      electrics.values.p1RegenThrottle = 0
      if input.throttle > 1e-2 then
        engine.ignitionCoef = 1
        electrics.values.p1Throttle = 1
      else
        electrics.values.p1Throttle = 0
      end
    else
      if engine.outputAV1 >= engageAV and p1State == 1 then
        p1State = 0
      end
      idlingTime = 0
      engine.ignitionCoef = 1
      electrics.values.p1Throttle = 0
      if input.throttle > 1e-2 then
        electrics.values.p1RegenThrottle = 0
      else
        electrics.values.p1RegenThrottle = 1 - electrics.values.remainingBatteryRatio
      end
    end
  else
    p1State = 1
    idlingTime = 0
    engine.ignitionCoef = 0
    electrics.values.p1Throttle = 0
    electrics.values.p1RegenThrottle = 0
  end
end

local function updateGFX(dt)
  updateMotorIgnition()
  updateBatteryState()
  updateEHSState(dt)
end

local function serialize()
end

local function deserialize(data)
end

local function init(jbeamData)
  engine = powertrain.getDevice(jbeamData.engineName) or powertrain.getDevice("mainEngine")
  p1_Motors = powertrain.getDevicesByType("p1_Motor")
  engageRPM = jbeamData.engageRPM or 1500
  engageAV = engageRPM * rpmToAV
end

local function initLastStage(jbeamData)
end

M.init = init
M.initLastStage = initLastStage
M.updateMotorIgnition = updateMotorIgnition
M.updateBatteryState = updateBatteryState
M.updateEHSState = updateEHSState
M.updateGFX = updateGFX
M.serialize = serialize
M.deserialize = deserialize

return M
