local htmlTexture = require("htmlTexture")
local M = { engineInfo = {} }

local function onInit()
  htmlTexture.create('@SVG70_dashscreen', 'local://local/vehicles/SVG70/gauges_screen/dash.html', 1024, 1024, 30, 'automatic')
end

local function reset()
  onInit()
end

local function updateGFX(dt)
  htmlTexture.call('@SVG70_dashscreen', 'setVehicleData', {
    dt             = dt,
    rpm            = electrics.values.rpmTacho       or 0,
    speed          = electrics.values.wheelspeed     or 0,
    gear           = electrics.values.gear           or '?',
    ignition       = electrics.values.ignition       or false,
    ignitionLevel  = electrics.values.ignitionLevel  or 0,
    running        = electrics.values.running        or false,
    signalL        = electrics.values.signal_L       == 1,
    signalR        = electrics.values.signal_R       == 1,
    oiltemp        = electrics.values.oiltemp        or 0,
    fuelVolume     = electrics.values.fuelVolume     or 0,
    fuelCapacity   = electrics.values.fuelCapacity   or 1,
    engineLoad     = electrics.values.engineLoad     or 0,
    engineThrottle = electrics.values.engineThrottle or 0,
    boost          = electrics.values.boost          or 0,
    boostMax       = electrics.values.boostMax       or 0,
  })
end

-- public interface
M.onInit    = onInit
M.reset     = reset
M.updateGFX = updateGFX

return M
