console.log("load gaugesScreen");
angular.module('gaugesScreen', [])
.directive('bngMapRenderUncompressed', function () {
  return {
    template: `<svg width="100%" height="100%" class="container"></svg>`,
    scope: {
      map: '<',
      color: '@?',
      width: '@?',
      drivability: '@?'
    },
    replace: true,
    restrict: 'E',
    link: function (scope, element, attrs) {
      "use strict";
      var svg = element[0]
        , mapScale = 1
        , domElems = {}
        , getColor = (rClass) => scope.color || (rClass === 0 ? 'black' : 'white') // if there is a color set use that otherwise use the defaults
        ;


      function isEmpty (obj) {
        return Object.keys(obj).length === 0;
      }

      function calcRadius (radius) {
        return  Math.min(Math.max(radius, 0), 5) * 3
      }

      scope.$watch('map', function (newVal) {
        if (newVal && !isEmpty(newVal)) {
          setupMap(newVal, angular.element(svg));
        }
      })

      function _createLine(p1, p2, color) {
         return hu('<line>', svg).attr({
          x1: p1.x, y1: p1.y, x2: p2.x, y2: p2.y,
          stroke: color,
          strokeWidth: Math.max(p1.radius, p2.radius),
          strokeLinecap: "round",
        });
      }

      function drawRoads(nodes, drivabilityMin, drivabilityMax) {
        var drawn = {};
        for (var key in nodes) {
          var el = nodes[key];
          // walk the links of the node
          if (el.links !== undefined) { // links
            for (var key2 in el.links) {
              var el2 = nodes[key2];
              var drivability = el.links[key2].drivability;
              if (el2 !== undefined) {
                if (drivability >= drivabilityMin && drivability <= drivabilityMax) {
                  // TODO: can we find a better key here please?
                  drawn[key + '.' + key2 + drivabilityMin + drivabilityMax] = true;
                  if (domElems[key + '.' + key2 + drivabilityMin + drivabilityMax] !== undefined) {
                    domElems[key + '.' + key2 + drivabilityMin + drivabilityMax].remove();
                  }
                  domElems[key + '.' + key2 + drivabilityMin + drivabilityMax] = _createLine({
                    x: el.pos[0] / mapScale,
                    y: -el.pos[1] / mapScale,
                    radius: calcRadius(el.radius)
                  }, {
                      x: el2.pos[0] / mapScale,
                      y: -el2.pos[1] / mapScale,
                      radius: calcRadius(el2.radius)    // prevents massive blobs due to waypoints having larger radius'
                    }, getColor(drivability)
                  );
                }
              }
            }
          }
        }

        // remove all elems that are from previous calls
        for (var key in domElems) {
          if (!drawn[key] && key.endsWith('' + drivabilityMin + drivabilityMax)) {
            domElems[key].remove()
            domElems[key] = undefined; // delete domNode reference and allow for gc
          }
        }
      }

      function setupMap(data) {
        if (data != null) {

          svg.setAttribute('viewBox', data.viewParams.join(' '));

          // draw dirt roads and then normal on top
          if (scope.drivability !== 'false') {
            drawRoads(data.nodes, 0, 0.9);
            drawRoads(data.nodes, 0.9, 1);
          } else {
            drawRoads(data.nodes, 0, 1);
          }
        }
      }
    }
  };
})

  .controller('C187Controller', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];

    var speedo = {  };
    var tacho = {  };

    var backgroundGradient = {};
    var overlayGradient = {};
    var navMarkerGradient = {};
    // var backgroundClipGradient;

    var speedoInitialised = true;
    var currentGear = '';
    var cachedAng = {speedo:-100, tacho:-100, temp:-100, fuel:-100};
    var refreshAng = 0.25*Math.PI/180;

    var ready = false;

    var unitspeedConv = 3.6;
    var unitspeedratio = 2.0*Math.PI*1.5/260;
    var rpmRatio = 0.1;

    var painduchocolat = {}; //une tradi bien cuite s'il vous plait

    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
      svg = $element[0].children[0].children[0];

      //painduchocolat.root = hu('#layer_wip', svg);
      //painduchocolat.txt = hu('#wip.txt', painduchocolat.root);

      speedo.root = hu('#speedo', svg);
      speedo.gear = hu('#geartext', speedo.geartext);
      speedo.gpsspeed = hu("#gpsspeed", speedo.gpsspeed)
      speedo.volts = hu("#volts", speedo.volts)
      speedo.watertemp = hu("#watertemp", speedo.watertemp)
      speedo.oiltemp = hu("#oiltemp", speedo.oiltemp)
      speedo.oilpressure = hu("#oilpressure", speedo.oilpressure)

      tacho.root = hu('#tacho', svg);

      tacho.Ticks = hu('#rpmTicks', tacho.Ticks);
      tacho.TicksSmall = hu('#rpmTicksSmall', tacho.TicksSmall);
      tacho.TicksText  = hu('#rpmTicksText', tacho.TicksText);

      tacho.TicksSmall.css({'stroke': `rgba(0, 0, 0, 1)`, 'stroke-width': '0.5px'});
      tacho.Ticks.css({'stroke': `rgba(0, 0, 0, 1)`, 'stroke-width': '1px'});

      tacho.rpmRedline = hu('#rpmRedline', tacho.root);


      tacho.rpm = hu('#rpm', tacho.rpm),

      tacho.rpmFill = hu('#rpmFill', tacho.rpmFill),

      tacho.rpmOverflowStationary = hu('#rpmOverflowStationary', tacho.rpmOverflowStationary),
      tacho.rpmOverflow = hu('#rpmOverflowMoving', tacho.rpmOverflow),
      tacho.rpmOverflow2 = hu('#rpmOverflowMoving2', tacho.rpmOverflow2),

      ready = true;
    }

    function updateGearIndicator(data) {
      if (currentGear != data.gear) {
        speedo.gear.text(data.gear)
        currentGear = data.gear
      }
    }

    function updateTachoDisplays(data) {
      if (speedoInitialised) {
        var speedAng = 150 + ((data.rpm * 0.05));
        var startAngle=-105*180*Math.PI/180 + 0.04
        var speedRad = (data.rpm * rpmRatio)-startAngle;
        var maxRad = (275*Math.PI/180) + startAngle;
        speedRad = Math.max(speedRad, maxRad);
        //console.info(speedRad)
        if(Math.abs(speedRad-cachedAng.tacho)<0.3){return;}

        //console.log("maxRad",maxRad,"start",startAngle,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad-startAngle)*180/Math.PI);

        var centerX=135.5, centerY=133.5, radiusInt=61.7, radiusExt=0.0, largeArcFlag= ((speedRad+startAngle)>Math.PI)? 1 : 0, radiusExtH = radiusExt-1;
        //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);

        var sx2 = (centerX) + Math.cos(startAngle - 0.2) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle - 0.2) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(speedRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(speedRad) * radiusExt;

        var ex1 = (centerX) + Math.cos(speedRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(speedRad) * radiusInt;

        var mx1 = (centerX) + Math.cos(speedRad) * 15;
        var my1 = (centerY) + Math.sin(speedRad) * 15;

        tacho.rpmFill.attr({d: "M " + sx1 + "," + sy1 +
          " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
          " L " + ex1 + "," + ey1 +
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2
        });
        tacho.rpm.attr({d: "M " + ex1 + "," + ey1 + " " + mx1 +"," + my1});
        //tacho.rpm.attr({cx:ex1,cy:ey1,fx:ex1,fy:ey1});

        cachedAng.tacho = speedAng;
      }
    }

    $window.redrawTachoTicks = (lim,bigSep,smallSep,red) => {
      var startAngle= -110;
      var maxAngle = 185;
      var centerX=135.5, centerY=133.5, radiusInt=57, radiusExt=61.7, radiusIntBig=57;
      rpmRatio = maxAngle*Math.PI/(lim*180);

      var tickD = "";
      for(var ib = 0; ib<= (lim/bigSep) ; ib++){
        for(var is = 0; is<= (bigSep/smallSep); is++){
          var curAng = (ib*maxAngle/(lim/bigSep)+maxAngle*(1/(lim/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng > (maxAngle*Math.PI/180)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }
      tacho.Ticks.attr({d: tickD});

      var tickSmallD = "";
      var limSmall = lim * 5
      for(var ib = 0; ib<= (limSmall/bigSep) ; ib++){
        for(var is = 0; is<= (bigSep/smallSep); is++){
          var curAng = (ib*maxAngle/(limSmall/bigSep)+maxAngle*(1/(limSmall/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng > (maxAngle*Math.PI/180)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig + 2:radiusInt + 2);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig + 2:radiusInt + 2);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickSmallD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }
      tacho.TicksSmall.attr({d: tickSmallD});

      var txtRadius = 45;
      var testStyle = {"font-size":8+"px","font-style":"normal","font-weight":"bold","font-stretch":"normal","font-family":"NewsCycle","fill-opacity":1,"stroke-width":0.09,"text-align":"center","text-anchor":"middle"};

      tacho.TicksText.empty();
      for(var ib = 0; ib<=(lim/bigSep) ; ib++){
        var curAng = (ib*maxAngle/(lim/bigSep)) *Math.PI/180;
        var sx = (centerX) + Math.cos(startAngle+curAng) * txtRadius;
        var sy = (centerY + 0.90) + Math.sin(startAngle+curAng) * txtRadius;
        var ts = hu('<tspan>', tacho.TicksText)
        .attr({x: sx,y: sy})
        .text((ib*bigSep*0.001))
        .css(testStyle)
        .css({"fill":"#00000ff"});
      }

      //redline stuffs
      var centerX=135.5, centerY=133.5, radiusInt=63, radiusExt=64.5, radiusIntBig=63;
      var redlineD = "";
      for(var ib = 0; ib<= (lim*10/bigSep) ; ib++){
        for(var is = 0; is<= (lim*10/bigSep); is++){
          var curAng = (ib*maxAngle/(lim*10/bigSep)+maxAngle*(1/(lim*10/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng > (maxAngle*Math.PI/180)){break;}

          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;

          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);

          if (ib*bigSep >= red*10)  {
            redlineD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
          }
        }
      }
      tacho.rpmRedline.attr({d: redlineD});
      //
    }

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }

      redrawTachoTicks(data.maxRPM,1000,500,data.redRPM);

      if (data.colorRed) {
        tacho.rpmRedline.css({'stroke': `rgba(230, 0, 0, 1)`, 'stroke-width': '2px'});
        tacho.rpmOverflow.css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        tacho.rpmFill.css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        tacho.rpm.css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        tacho.rpmFillRectangle = hu('#path149164-3-9-7-0-3', tacho.rpmFillRectangle),
        tacho.rpmFillRectangle.css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});

        //texts
        hu('#tspan3071', tacho.text3073).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        hu('#tspan3071-6', tacho.text3073-5).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        hu('#tspan3071-6-1', tacho.text3073-5-7).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        hu('#tspan3071-7', tacho.text3073-0).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        hu('#tspan3071-6-6', tacho.text3073-5-6).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        hu('#tspan3071-6-1-5', tacho.text3073-5-7-4).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        hu('#tspan3071-6-1-57', tacho.text3073-5-7-0).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        hu('#tspan3071-6-1-57-8', tacho.text3073-5-7-0-6).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        hu('#tspan3071-6-1-57-0', tacho.text3073-5-7-0-7).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        hu('#tspan126858', tacho.text126860).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
        hu('#tspan126858-7', tacho.text126860-5).css({'stroke': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`, 'stroke-width': '0.5px', 'fill': `rgb(${data.colorRed}, ${data.colorGreen}, ${data.colorBlue})`});
      }
    }

    $window.initMap = (data) => {
      navDimensions = data.viewParams = [
        data.terrainOffset[0],
        data.terrainOffset[1],
        data.terrainSize[0],
        data.terrainSize[1]
      ];

      $scope.$apply(() => {
        vm.mapData = data;
      });

      navContainer.style.width = data.terrainSize[0] + "px";
      navContainer.style.height = data.terrainSize[1] + "px";
    }

    $window.updateMap = (data) => {
      var focusX = -data.x;
      var focusY = data.y;
      var origin = `${((navDimensions[0] * -1)) - focusX}px ${((navDimensions[1] * -1)) - focusY}px`;
      navContainer.style.transformOrigin = origin;
      var translateX = ((((navDimensions[0])) + 512) + focusX);
      var translateY = ((((navDimensions[1])) + 256) + focusY);
      navContainer.style.transform = `translate3d(${translateX}px,${translateY}px, 0px) rotateX(${55}deg) rotateZ(${180 + (data.rotation + 360)}deg) scale(1)`;
    }

    $window.updateElectrics = (data) => {
      speedo.oilpressure.text(data.oilPressure.toFixed(1))
      speedo.oiltemp.text((data.oiltemp * 9/5 + 32).toFixed(1))
      speedo.watertemp.text((data.watertemp * 9/5 + 32).toFixed(2))
      speedo.volts.text(data.volts.toFixed(2))
      speedo.gpsspeed.text((data.gpsSpeed * 2.236936).toFixed(2))
    }

    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        // Update PRNDS display
        updateGearIndicator(data);
        // Update Speed displays
        //updateSpeedDisplays(data);
        updateTachoDisplays(data);

        updateElectrics(data);
      }
    }
    //ready = true;
    //$window.updateConsum({current:0, average:0, range:0});
  });