-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local min = math.min
local max = math.max

local gaugesScreenName = nil
local htmlPath = nil
local gaugeHTMLTexture = nil

local updateTimer = 0
local updateFPS = 30
local invFPS = 1 / updateFPS

local pressureSmoother = newExponentialSmoothing(25)
local engine = nil
local oilPressure = 0
local oilPressureRaw = 0
local viscosity = 15000

local voltSmoother = newExponentialSmoothing(10)

local maxRPM = 0
local redRPM = 0

local function updateGFX(dt)
  local evals = electrics.values

  -- OIL PRESSURE
  local temp = 200 - evals.oiltemp
  oilPressureRaw = ((temp * (evals.rpm / viscosity) / 120) + 1.1) * engine.oilVolume
  oilPressure = oilPressureRaw * (clamp(evals.rpm, 0, engine.idleAV / 0.104719755) / (engine.idleAV / 0.104719755))
  oilPressure = pressureSmoother:get(oilPressure * 4.54545454)

  if oilPressure < 1.5 and engine.ignitionCoef ~= 0 then
    evals.motecOilPressureWarn = 1
  else
    evals.motecOilPressureWarn = 0
  end
  -- OIL / WATER TEMP
  if evals.watertemp > 120 then evals.motecWaterTempWarn = 1 else evals.motecWaterTempWarn = 0 end
  if evals.oiltemp > 120 then evals.motecOilTempWarn = 1 else evals.motecOilTempWarn = 0 end
  --

  updateTimer = updateTimer + dt
  if updateTimer > invFPS and playerInfo.anyPlayerSeated then
    local data = {}

    -- "real" values
    data.maxRPM = maxRPM
    data.redRPM = redRPM
    data.oilPressure = oilPressure
    data.watertemp = evals.watertemp
    data.oiltemp = evals.oiltemp
    data.gpsSpeed = evals.airspeed
    data.rpm = evals.rpmTacho

    if type(evals.gearIndex) == "number" and evals.gearIndex == 0 then
      data.gear = "N"
    elseif type(evals.gearIndex) == "number" and evals.gearIndex <= -1 then
      data.gear = "R"
    else
      data.gear = evals.gearIndex
    end

    -- fake values
    data.volts = voltSmoother:get(12.2 + math.random(-0.7, 0.7))
    data.convTempOut = 290
    data.transTemp = 280
    data.transPsi = 60
    data.fuelPsi = 48

    gaugeHTMLTexture:callJS("updateData", data)
  end
end

local function initSecondStage(jbeamData)
  gaugesScreenName = jbeamData.gaugesScreenName or "@motec_c187_gauges_screen"
  htmlPath = jbeamData.htmlFilePath or "local://local/vehicles/pickup/motec_screen/screen.html"

  local width = 1024
  local height = 1024

  maxRPM = jbeamData.maxRPM or 8000
  redRPM = jbeamData.redRPM or 7000

  local evals = electrics.values

  local data = {
    maxRPM = maxRPM,
    redRPM = redRPM,
    oilPressure = 40,
    watertemp = evals.watertemp,
    oiltemp = evals.oiltemp,
    gpsSpeed = evals.airspeed,
    volts = voltSmoother:get(12.2 + math.random(-0.7, 0.7)),
    convTempOut = 290,
    transTemp = 280,
    transPsi = 60,
    fuelPsi = 48,

    colorRed = jbeamData.colorRed,
    colorGreen = jbeamData.colorGreen,
    colorBlue = jbeamData.colorBlue,
  }

  if not gaugesScreenName then
    log("E", "motecScreen", "Got no material name for the texture, can't display anything...")
    M.updateGFX = nop
  else
    if htmlPath then
      gaugeHTMLTexture = htmlTexture.new(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
      gaugeHTMLTexture:callJS("setup", data)
    else
      log("E", "motecScreen", "Got no html path for the texture, can't display anything...")
      M.updateGFX = nop
    end
  end

  for _, e in pairs(powertrain.getDevicesByType("combustionEngine")) do
    engine = e
	end

  -- LIGHTS --
  local evals = electrics.values
  -- these cannot be used
  evals.motecVoltsWarn = 0
  evals.motecConvTempWarn = 0
  evals.motecTransTempWarn = 0

  -- these can be used
  evals.motecWaterTempWarn = 0
  evals.motecOilTempWarn = 0
  evals.motecOilPressureWarn = 0

  -- shiftlights (ended up using shiftLights.lua)
  -- evals.motec_dash_lights_shift1 = 0
  -- evals.motec_dash_lights_shift2 = 0
  -- evals.motec_dash_lights_shift3 = 0
  -- evals.motec_dash_lights_shift4 = 0
  -- evals.motec_dash_lights_shift5 = 0
end

local function reset()
  local data = {
    maxRPM = maxRPM,
    redRPM = redRPM
  }
  gaugeHTMLTexture:callJS("setup", data)
end

M.initSecondStage = initSecondStage
M.reset = reset
M.init = nop
M.updateGFX = updateGFX

return M
