local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local mode = 0
local modeNames = {"Opposite", "Front Steer Only", "Parallel"}
local ffactor = 1
local rfactor = 1

local function onInit()
	electrics.values.fw_steering_input = 0
	electrics.values.rw_steering_input = 0
end

local function updateGFX(dt)
	electrics.values.fw_steering_input = electrics.values.steering_input * ffactor
	electrics.values.rw_steering_input = electrics.values.steering_input * rfactor
end

local function updateMode()
  gui.message("4WS Mode Set To " .. modeNames[mode+1], 3, "D-15 4ws") -- we use mode+1 here because lua tables start at 1, so mode 0 (Opposite) would be at modeNames[1]

	if mode == 0 then
		ffactor = 1
		rfactor = 1
	elseif mode == 1 then
		ffactor = 1
		rfactor = 0
	elseif mode == 2 then
		ffactor = 1
		rfactor = -1
	end
end

local function nextMode()
  mode = (mode + 1) % 3 -- wrap around to 0 if it's >= 3
  updateMode()
end

local function previousMode()
  mode = mode - 1
  if mode < 0 then mode = 2 end
  updateMode()
end



-- at the end of the lua as always
M.onInit = onInit
M.updateGFX = updateGFX

M.nextMode = nextMode
M.previousMode = previousMode
return M
