local M = {}

local triggerStates = { console = 0, leftsunvisor = 0, rightsunvisor = 0, glovebox = 0 }
local isOpen = { console = false, leftsunvisor = false, rightsunvisor = false, glovebox = false }
local positions = { console = 0, leftsunvisor = 0, rightsunvisor = 0, glovebox = 0 }

local speeds = {
    console = 1.0,
    leftsunvisor = 1.0,
    rightsunvisor = 1.0,
    glovebox = 1.0
}

local maxPositions = {
    console = 0.75,
    leftsunvisor = 1.0,
    rightsunvisor = 1.0,
    glovebox = 1.0
}

local function handleTrigger(part, dt)
    local triggerValue = electrics.values[part .. "_trigger"] or 0

    if triggerValue == 1 and triggerStates[part] == 0 then
        isOpen[part] = not isOpen[part]
    end

    if isOpen[part] then
        positions[part] = math.min(positions[part] + speeds[part] * dt, maxPositions[part])
    else
        positions[part] = math.max(positions[part] - speeds[part] * dt, 0)
    end

    electrics.values[part] = positions[part]
    triggerStates[part] = triggerValue
end

local function updateGFX(dt)
    if not electrics then return end
    handleTrigger("console", dt)
    handleTrigger("leftsunvisor", dt)
    handleTrigger("rightsunvisor", dt)
    handleTrigger("glovebox", dt)
end

local function resetPart(part)
    if electrics then
        electrics.values[part] = 0
        electrics.values[part .. "_trigger"] = 0
    end
    triggerStates[part] = 0
    isOpen[part] = false
    positions[part] = 0
end

local function onReset()
    resetPart("console")
    resetPart("leftsunvisor")
    resetPart("rightsunvisor")
    resetPart("glovebox")
end

local function onVehicleActiveChanged(active)
    if active then
        electrics.registerHandler("updateGFX", updateGFX)
        onReset()
    end
end

M.onVehicleActiveChanged = onVehicleActiveChanged
M.onReset = onReset
M.updateGFX = updateGFX

return M