local scheduler = require('timeEvents').create()

local Module = {}

local componentGroups = {
    mainSunroof = { "panoramicroof", "panoramicrooffl", "panoramicrooffr", "panoramicroofrl", "panoramicroofrr" },
}

local function resetVehicle()
    for groupName, components in pairs(componentGroups) do
        if electrics.values[groupName] == 1 then
            electrics.values[groupName] = 0

            local function reToggleComponents()
                electrics.values[groupName] = 1
                for i = 1, #components do
                    local comp = controller.getControllerSafe(components[i])
                    if comp and comp.toggleGroup then
                        comp.toggleGroup()
                    end
                end
            end

            scheduler:addEvent(0.1, reToggleComponents)
        end
    end
end

local function onFrameUpdate(deltaTime)
    scheduler:process(deltaTime)
end

Module.onReset = resetVehicle
Module.updateGFX = onFrameUpdate

return Module