local M = {}

local lastTriggerStateC = 0
local lastTriggerStateVL = 0
local lastTriggerStateVR = 0
local lastTriggerStateGB = 0

local isExtendedC = false
local isExtendedVL = false
local isExtendedVR = false
local isExtendedGB = false

local console_position = 0
local CONSOLE_SPEED = 1.0

local visorL_position = 0
local visorR_position = 0
local glovebox_position = 0
local VISOR_SPEED = 1.0
local GLOVEBOX_SPEED = 1.0

local function updateGFX(dt)
    if not electrics then return end
    
    local currentTriggerC = electrics.values.console_trigger or 0
    local currentTriggerVL = electrics.values.visorL_trigger or 0
    local currentTriggerVR = electrics.values.visorR_trigger or 0
    local currentTriggerGB = electrics.values.glovebox_trigger or 0

    if currentTriggerC == 1 and lastTriggerStateC == 0 then
        isExtendedC = not isExtendedC
    end
    if isExtendedC then
        console_position = console_position + CONSOLE_SPEED * dt
        if console_position > 0.6 then 
            console_position = 0.6
        end
    else
        console_position = console_position - CONSOLE_SPEED * dt
        if console_position < 0 then 
            console_position = 0
        end
    end
	electrics.values.console = console_position
	
    if currentTriggerVL == 1 and lastTriggerStateVL == 0 then
        isExtendedVL = not isExtendedVL
    end
    if isExtendedVL then
        visorL_position = visorL_position + VISOR_SPEED * dt
        if visorL_position > 1 then 
            visorL_position = 1
        end
    else
        visorL_position = visorL_position - VISOR_SPEED * dt
        if visorL_position < 0 then 
            visorL_position = 0
        end
    end
    electrics.values.visorL = visorL_position
    
    if currentTriggerVR == 1 and lastTriggerStateVR == 0 then
        isExtendedVR = not isExtendedVR
    end
    if isExtendedVR then
        visorR_position = visorR_position + VISOR_SPEED * dt
        if visorR_position > 1 then 
            visorR_position = 1
        end
    else
        visorR_position = visorR_position - VISOR_SPEED * dt
        if visorR_position < 0 then 
            visorR_position = 0
        end
    end
    electrics.values.visorR = visorR_position

    if currentTriggerGB == 1 and lastTriggerStateGB == 0 then
        isExtendedGB = not isExtendedGB
    end
    if isExtendedGB then
        glovebox_position = glovebox_position + GLOVEBOX_SPEED * dt
        if glovebox_position > 1 then 
            glovebox_position = 1
        end
    else
        glovebox_position = glovebox_position - GLOVEBOX_SPEED * dt
        if glovebox_position < 0 then 
            glovebox_position = 0
        end
    end
    electrics.values.glovebox = glovebox_position
    
    lastTriggerStateC = currentTriggerC
    lastTriggerStateVL = currentTriggerVL
    lastTriggerStateVR = currentTriggerVR
    lastTriggerStateGB = currentTriggerGB
end

local function onReset()
    if electrics then
        electrics.values.console = 0
        electrics.values.console_trigger = 0
        lastTriggerStateC = 0
        isExtendedC = false
        console_position = 0
        
        electrics.values.visorL = 0
        electrics.values.visorL_trigger = 0
        lastTriggerStateVL = 0
        isExtendedVL = false
        visorL_position = 0
        
        electrics.values.visorR = 0
        electrics.values.visorR_trigger = 0
        lastTriggerStateVR = 0
        isExtendedVR = false
        visorR_position = 0

        electrics.values.glovebox = 0
        electrics.values.glovebox_trigger = 0
        lastTriggerStateGB = 0
        isExtendedGB = false
        glovebox_position = 0
    end
end


local function onVehicleActiveChanged(active)
    if active then
        electrics.registerHandler("updateGFX", updateGFX)
        onReset()
    end
end

M.onVehicleActiveChanged = onVehicleActiveChanged
M.onReset = onReset
M.updateGFX = updateGFX

return M