-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

--local debugDrawer = obj.debugDrawProxy
local parkingSensorData = {}
local parkingSensorEnabled = false
M.parkingSensorHits = { parkingSensorMinDist=2, parkingSensorMinDistFront=2, parkingSensorMinDistFrontActual=2, parkingSensorMinDistRear=2, parkingSensorMinDistRearActual=2, frontBumper = {}, rearBumper = {} }
local parkingSensorSoundTimer = 0
local parkingSensorTurnOffTimer = 0
local parkingSensorSpeedThreshold = math.huge
local parkingSensorSoundOnce
local parkingSensorSoundContinuous
local parkingCurrentSensor = 1

local brokenBreakGroupCache = {}
local n = beamstate.nodeNameMap
local soundFileOnce = ""
local soundFileContinuous = ""

local frontSoundActive = true
local rearSoundActive = true
local frontActive = true
local rearActive = true
local frontSoundVolume = 1
local rearSoundVolume = 1

local triangleData = lpack.decode(obj:getLastMailbox("zeitADASVehTris")) or {}

local function castRayParkingSensor(origin, dir, staticOnly, maxDistance, mailboxData)
    local staticRay = obj:castRayStatic(origin, dir, maxDistance)
    local vehicleRay = maxDistance

    if not staticOnly then
        for othervehid, otherveh in pairs(mailboxData) do
            if othervehid == objectId or math.abs(intersectsRay_OBB(origin, dir, otherveh.center, otherveh.x, otherveh.y, otherveh.z)) > 6 then goto skip_vehicle end

            local otherVehSensors = controller.getController("zeitADAS").otherVehSensors
            local otherObj = otherVehSensors.objects[othervehid]
            if not otherObj or not triangleData[othervehid] then goto skip_vehicle end
            for _, colTri in pairs(triangleData[othervehid]) do
                if not colTri.id1 then break end
                local otherObjPos = otherObj:getPosition()
                local nodePos1 = otherObj:getNodePosition(colTri.id1)+otherObjPos

                local newRay = math.huge
                if nodePos1:distance(origin) < vehicleRay then
                    --debugDrawer:drawLine(nodePos1, nodePos2, color(255,255,0,255))
                    --debugDrawer:drawLine(nodePos2, nodePos3, color(255,255,0,255))
                    --debugDrawer:drawLine(nodePos3, nodePos1, color(255,255,0,255))
                    newRay = intersectsRay_Triangle(origin, dir, nodePos1, otherObj:getNodePosition(colTri.id2)+otherObjPos, otherObj:getNodePosition(colTri.id3)+otherObjPos)
                end
                vehicleRay = math.min(newRay >= 0 and newRay or math.huge, vehicleRay)
            end

            ::skip_vehicle::
        end
    end

    local combinedRay = math.min(staticRay, vehicleRay)
    --[[
    debugDrawer:drawLine(origin, origin+dir, color(255,0,0,255))
    debugDrawer:drawSphere(0.05, origin+(dir*combinedRay), color(255,0,0,255))
    ]]

    return combinedRay
end

local function runCheckParkingSensorsFront(mailboxData)
    if brokenBreakGroupCache[parkingSensorData.frontBumperBreakGroupName] then
        --M.parkingSensorHits.frontBumper = {}
        M.parkingSensorHits.parkingSensorMinDistFrontActual = 2
        return 1
    end

    parkingCurrentSensor = parkingCurrentSensor + 1
    if parkingCurrentSensor > #parkingSensorData.frontBumper then
        parkingCurrentSensor = 0
        --M.parkingSensorHits.frontBumper = {}
        M.parkingSensorHits.parkingSensorMinDistFrontActual = M.parkingSensorHits.parkingSensorMinDistFront
        M.parkingSensorHits.parkingSensorMinDistFront = 2
        M.parkingSensorHits.parkingSensorMinDistRear = 2
        return 1
    end

    local vehPos = obj:getPosition()
    local vehRot = quat(obj:getRotation()):normalized()

    local currentSensorSettings = parkingSensorData.frontBumper[parkingCurrentSensor]
    local currentSensor = { vehPos+obj:getNodePosition(n[currentSensorSettings.startNode])+currentSensorSettings.offsetVec:rotated(vehRot), currentSensorSettings.dirVec:rotated(vehRot) }

    local ray = castRayParkingSensor(currentSensor[1], ((currentSensor[2]+currentSensor[1])-currentSensor[1]):normalized(), currentSensorSettings.isStaticOnly, 2, mailboxData)
    --table.insert(M.parkingSensorHits.frontBumper, ray)
    M.parkingSensorHits.frontBumper[parkingCurrentSensor] = ray
    M.parkingSensorHits.parkingSensorMinDistFront = math.min(M.parkingSensorHits.parkingSensorMinDistFront, ray)
    electrics.values.parkingSensorHits.frontBumper[parkingCurrentSensor] = ray

    electrics.values.parkingSensorShow = (electrics.values.parkingSensorShow == 1 or ray ~= 2) and 1 or 0

    return 0
end

local function runCheckParkingSensorsRear(mailboxData)
    if brokenBreakGroupCache[parkingSensorData.rearBumperBreakGroupName] then
        --M.parkingSensorHits.rearBumper = {}
        M.parkingSensorHits.parkingSensorMinDistRearActual = 2
        return 0
    end

    parkingCurrentSensor = parkingCurrentSensor + 1
    if parkingCurrentSensor > #parkingSensorData.rearBumper then
        parkingCurrentSensor = 0
        --M.parkingSensorHits.rearBumper = {}
        M.parkingSensorHits.parkingSensorMinDistRearActual = M.parkingSensorHits.parkingSensorMinDistRear
        M.parkingSensorHits.parkingSensorMinDistFront = 2
        M.parkingSensorHits.parkingSensorMinDistRear = 2
        return 0
    end

    local vehPos = obj:getPosition()
    local vehRot = quat(obj:getRotation()):normalized()

    local currentSensorSettings = parkingSensorData.rearBumper[parkingCurrentSensor]
    local currentSensor = { vehPos+obj:getNodePosition(n[currentSensorSettings.startNode])+currentSensorSettings.offsetVec:rotated(vehRot), currentSensorSettings.dirVec:rotated(vehRot) }

    local ray = castRayParkingSensor(currentSensor[1], ((currentSensor[2]+currentSensor[1])-currentSensor[1]):normalized(), currentSensorSettings.isStaticOnly, 2, mailboxData)
    --table.insert(M.parkingSensorHits.rearBumper, ray)
    M.parkingSensorHits.rearBumper[parkingCurrentSensor] = ray
    M.parkingSensorHits.parkingSensorMinDistRear = math.min(M.parkingSensorHits.parkingSensorMinDistRear, ray)
    electrics.values.parkingSensorHits.rearBumper[parkingCurrentSensor] = ray

    electrics.values.parkingSensorShow = (electrics.values.parkingSensorShow == 1 or ray ~= 2) and 1 or 0

    return 1
end

local function doParkingSensorSound(dt, val, soundMultiplier)
    if not parkingSensorSoundOnce then
        parkingSensorSoundOnce = obj:createSFXSource2(soundFileOnce or "", "Audio2D", "parkingSensorSoundOnce", 0, 0)
    end
    if not parkingSensorSoundContinuous then
        parkingSensorSoundContinuous = obj:createSFXSource2(soundFileContinuous or "", "AudioLoop2D", "parkingSensorSoundContinuous", 0, 0)
    end

    local volume = 0.75*soundMultiplier

    local isInCar = controller.getController("zeitADAS").isInCar
    obj:setVolume(parkingSensorSoundContinuous, isInCar and volume or 0)

    parkingSensorTurnOffTimer = 0
    parkingSensorSoundTimer = parkingSensorSoundTimer + dt

    if val < 0.4 then
        parkingSensorTurnOffTimer = 0
        if not obj:isPlayingSFX(parkingSensorSoundContinuous) then
            obj:playSFX(parkingSensorSoundContinuous)
        end
    elseif val < 1.5 then
        local maxTimer = (val < 0.7 and 0.15) or (val < 0.9 and 0.3) or (val < 1.2 and 0.5) or 0.7
        if parkingSensorSoundTimer > maxTimer then
            obj:playSFXOnce("parkingSensorSoundOnce", 0, volume, isInCar and 1 or 0)
            parkingSensorSoundTimer = 0
        end
        if obj:isPlayingSFX(parkingSensorSoundContinuous) then
            obj:stopSFX(parkingSensorSoundContinuous)
        end
    else
        if parkingSensorTurnOffTimer == 1 then
            obj:stopSFX(parkingSensorSoundContinuous)
        end
        parkingSensorTurnOffTimer = parkingSensorTurnOffTimer + 1
    end
end

local timer = 0
local function zeitADASUpdate(dt, mailboxData)
    if parkingSensorEnabled and electrics.values.parkingSensorsEnabled == 1 and electrics.values.wheelspeed < parkingSensorSpeedThreshold then
        if electrics.values.gearIndex > 0 then
            if frontSoundActive then
                doParkingSensorSound(dt, M.parkingSensorHits.parkingSensorMinDistFrontActual, frontSoundVolume)
            end
        elseif electrics.values.gearIndex == 0 and parkingSensorSoundContinuous then
            if obj:isPlayingSFX(parkingSensorSoundContinuous) then
                obj:stopSFX(parkingSensorSoundContinuous)
                obj:stopSFX(parkingSensorSoundOnce)
            end
        else
            if rearSoundActive then
                doParkingSensorSound(dt, M.parkingSensorHits.parkingSensorMinDistRearActual, rearSoundVolume)
            end
        end

        timer = timer + 1
        if timer == 2 then
            if frontActive then runCheckParkingSensorsFront(mailboxData) end
            if rearActive then runCheckParkingSensorsRear(mailboxData) end
            timer = 0
        elseif timer == 1 then
            triangleData = lpack.decode(obj:getLastMailbox("zeitADASVehTris")) or {}
        end
    else
        if parkingSensorSoundContinuous and obj:isPlayingSFX(parkingSensorSoundContinuous) then
            obj:stopSFX(parkingSensorSoundContinuous)
            obj:stopSFX(parkingSensorSoundOnce)
        end

        M.parkingSensorHits.parkingSensorMinDistFrontActual = 2
        M.parkingSensorHits.parkingSensorMinDistRearActual = 2
        electrics.values.parkingSensorShow = false
    end
end

local function init(jbeamData)
    parkingSensorEnabled = next(jbeamData)
    if parkingSensorEnabled then
        electrics.values.parkingSensorsEnabled = 1
        parkingSensorSpeedThreshold = jbeamData.activeSpeedKMH/3.6
        parkingSensorData = {
            frontBumper = tableFromHeaderTable(jbeamData.frontBumper or {}),
            rearBumper = tableFromHeaderTable(jbeamData.rearBumper or {}),
            frontBumperBreakGroupName = jbeamData.frontBumperBreakGroupName,
            rearBumperBreakGroupName = jbeamData.rearBumperBreakGroupName
        }

        for _,v in ipairs(parkingSensorData.frontBumper) do
            v.dirVec = vec3():fromString(v.direction)
            v.offsetVec = vec3():fromString(v.offset)
        end

        for _,v in ipairs(parkingSensorData.rearBumper) do
            v.dirVec = vec3():fromString(v.direction)
            v.offsetVec = vec3():fromString(v.offset)
        end

        for _,v in ipairs(parkingSensorData.frontBumper) do
            if not n[v.startNode] then
                parkingSensorEnabled = false
                log("D", "zeitADAS.parkingSensorInit", "A node specified for a front bumper sensor does not exist, aborting init")
                break
            end
        end
        for _,v in ipairs(parkingSensorData.rearBumper) do
            if not n[v.startNode] then
                parkingSensorEnabled = false
                log("D", "zeitADAS.parkingSensorInit", "A node specified for a rear bumper sensor does not exist, aborting init")
                break
            end
        end

        electrics.values.parkingSensorHits = {frontBumper = {}, rearBumper = {}}
        electrics.values.parkingSensorShow = false

        soundFileOnce = jbeamData.soundFileOnce or ""
        soundFileContinuous = jbeamData.soundFileContinuous or ""
    end
end

local function setFrontSoundActive(bool)
    frontSoundActive = bool

    if parkingSensorSoundContinuous and obj:isPlayingSFX(parkingSensorSoundContinuous) then
        obj:stopSFX(parkingSensorSoundContinuous)
        obj:stopSFX(parkingSensorSoundOnce)
    end
end

local function setRearSoundActive(bool)
    rearSoundActive = bool

    if parkingSensorSoundContinuous and obj:isPlayingSFX(parkingSensorSoundContinuous) then
        obj:stopSFX(parkingSensorSoundContinuous)
        obj:stopSFX(parkingSensorSoundOnce)
    end
end

local function setFrontActive(bool)
    frontActive = bool
    M.parkingSensorHits.parkingSensorMinDistFrontActual = 2
    M.parkingSensorHits.parkingSensorMinDistFront = 2

    if parkingSensorSoundContinuous and obj:isPlayingSFX(parkingSensorSoundContinuous) then
        obj:stopSFX(parkingSensorSoundContinuous)
        obj:stopSFX(parkingSensorSoundOnce)
    end
end

local function setRearActive(bool)
    rearActive = bool
    M.parkingSensorHits.parkingSensorMinDistRearActual = 2
    M.parkingSensorHits.parkingSensorMinDistRear = 2

    if parkingSensorSoundContinuous and obj:isPlayingSFX(parkingSensorSoundContinuous) then
        obj:stopSFX(parkingSensorSoundContinuous)
        obj:stopSFX(parkingSensorSoundOnce)
    end
end

local function setFrontSoundVolume(volume)
    frontSoundVolume = volume
end

local function setRearSoundVolume(volume)
    rearSoundVolume = volume
end

local function beamBroken(id)
    local beam = v.data.beams[id]

    if not beam or not beam.breakGroup then return end
    brokenBreakGroupCache[beam.breakGroup] = true
end

local function reset()
    if not parkingSensorSoundOnce then
        parkingSensorSoundOnce = obj:createSFXSource2(soundFileOnce or "", "Audio2D", "parkingSensorSoundOnce", 0, 0)
    end
    if not parkingSensorSoundContinuous then
        parkingSensorSoundContinuous = obj:createSFXSource2(soundFileContinuous or "", "AudioLoop2D", "parkingSensorSoundContinuous", 0, 0)
    end
    obj:stopSFX(parkingSensorSoundContinuous)
    obj:cutSFX(parkingSensorSoundContinuous)
    electrics.values.parkingSensorShow = false
    brokenBreakGroupCache = {}
end

M.beamBroken = beamBroken
M.setFrontSoundActive = setFrontSoundActive
M.setRearSoundActive = setRearSoundActive
M.setFrontSoundVolume = setFrontSoundVolume
M.setRearSoundVolume = setRearSoundVolume
M.setFrontActive = setFrontActive
M.setRearActive = setRearActive
M.zeitADASUpdate = zeitADASUpdate
M.init = init
M.reset = reset

return M