
local M = {}

local function onReset()
    electrics.values['lifter'] = 0
    electrics.values['lifter_input'] = 0
end

local function updateGFX(dt)
    electrics.values['lifter'] = math.min(1, math.max(-0.0, (electrics.values['lifter'] + electrics.values['lifter_input'] * dt * 0.2)))
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX

return M
