angular.module('gaugesScreen', [])
  .directive('bngMapRenderUncompressed', function () {
    return {
      template: `<svg width="100%" height="100%" class="container"></svg>`,
      scope: {
        map: '<',
        color: '@?',
        width: '@?',
        drivability: '@?'
      },
      replace: true,
      restrict: 'E',
      link: function (scope, element, attrs) {
        "use strict";
        var svg = element[0]
          , mapScale = 1
          , domElems = {}
          , getColor = (rClass) => scope.color || (rClass === 0 ? 'black' : 'white') // if there is a color set use that otherwise use the defaults
          ;


        function isEmpty(obj) {
          return Object.keys(obj).length === 0;
        }

        function calcRadius(radius) {
          return Math.min(Math.max(radius, 0), 5) * 3
        }

        scope.$watch('map', function (newVal) {
          if (newVal && !isEmpty(newVal)) {
            setupMap(newVal, angular.element(svg));
          }
        })

        function _createLine(p1, p2, color) {
          return hu('<line>', svg).attr({
            x1: p1.x, y1: p1.y, x2: p2.x, y2: p2.y,
            stroke: color,
            strokeWidth: Math.max(p1.radius, p2.radius),
            strokeLinecap: "round",
          });
        }

        function drawRoads(nodes, drivabilityMin, drivabilityMax) {
          var drawn = {};
          for (var key in nodes) {
            var el = nodes[key];
            // walk the links of the node
            if (el.links !== undefined) { // links
              for (var key2 in el.links) {
                var el2 = nodes[key2];
                var drivability = el.links[key2].drivability;
                if (el2 !== undefined) {
                  if (drivability >= drivabilityMin && drivability <= drivabilityMax) {
                    // TODO: can we find a better key here please?
                    drawn[key + '.' + key2 + drivabilityMin + drivabilityMax] = true;
                    if (domElems[key + '.' + key2 + drivabilityMin + drivabilityMax] !== undefined) {
                      domElems[key + '.' + key2 + drivabilityMin + drivabilityMax].remove();
                    }
                    domElems[key + '.' + key2 + drivabilityMin + drivabilityMax] = _createLine({
                      x: el.pos[0] / mapScale,
                      y: -el.pos[1] / mapScale,
                      radius: calcRadius(el.radius)
                    }, {
                      x: el2.pos[0] / mapScale,
                      y: -el2.pos[1] / mapScale,
                      radius: calcRadius(el2.radius)    // prevents massive blobs due to waypoints having larger radius'
                    }, getColor(drivability)
                    );
                  }
                }
              }
            }
          }

          // remove all elems that are from previous calls
          for (var key in domElems) {
            if (!drawn[key] && key.endsWith('' + drivabilityMin + drivabilityMax)) {
              domElems[key].remove()
              domElems[key] = undefined; // delete domNode reference and allow for gc
            }
          }
        }

        function setupMap(data) {
          if (data != null) {

            svg.setAttribute('viewBox', data.viewParams.join(' '));

            // draw dirt roads and then normal on top
            if (scope.drivability !== 'false') {
              drawRoads(data.nodes, 0, 0.9);
              drawRoads(data.nodes, 0.9, 1);
            } else {
              drawRoads(data.nodes, 0, 1);
            }
          }
        }
      }
    };
  })

  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];

    var speedoDisplay = { gears: {} };
    var tacho = {};
    var navDisplay = {};
    var infoDisplay = {};
    var consumGraph = { values: { current: 0, avg: 0 } };
    var electrics = { lights: {} };
    var gagues = { fuel: {}, temp: {} };
    var drivemodes = {};
    var bg = {};

    var backgroundGradient = {};
    var overlayGradient = {};
    var navMarkerGradient = {};
    // var backgroundClipGradient;

    var speedoInitialised = true;
    var currentGear = '';
    var cachedAng = { speedo: -100, tacho: -100, temp: -100, fuel: -100 };
    var refreshAng = 0.25 * Math.PI / 180;
    var rsTacho = false;

    var ready = false;

    var unit = "metric";
    var unitspeedConv = 3.6;
    var unitspeedratio = 2.0 * Math.PI * 1.5 / 260;
    var rpmRatio = 0.1;

    var painduchocolat = {}; //une tradi bien cuite s'il vous plait

    function updateClock() {
      let date = new Date();
      let h = date.getHours(); // 0 - 23
      let m = date.getMinutes(); // 0 - 59
      let s = date.getSeconds();
      //h = h%12 +1
      m = (m < 10) ? "0" + m : m
      let timeStr = h + ":" + m //+":" + s
      speedoDisplay.clock.text(timeStr)
      setTimeout(updateClock, 1000);
    }

    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
      svg = $element[0].children[0].children[0];

      painduchocolat.root = hu('#layer_wip', svg);
      painduchocolat.txt = hu('#wip.txt', painduchocolat.root);

      // speedometer non-RS
      speedoDisplay.root = hu('#speedometer', svg);
      speedoDisplay.speedometerText = hu('#speedometerText', speedoDisplay.root);
      speedoDisplay.speedometerText.fuelValue = hu('#fuelValue', speedoDisplay.speedometerText.root);
      speedoDisplay.speedValue = hu('#speedValue', speedoDisplay.speedometerText);
      speedoDisplay.speedValue10 = hu('#speedValue_ab10kmh', speedoDisplay.speedometerText);
      speedoDisplay.speedValue100 = hu('#speedValue_ab100kmh', speedoDisplay.speedometerText);
      speedoDisplay.speedUnit = hu('#speedUnit', speedoDisplay.speedometerText);
      speedoDisplay.speedTicks = hu('#speedTicks', speedoDisplay.speedometerText);
      speedoDisplay.speedTicks.css({ 'stroke': `rgba(255, 255, 255, 0.5)`, 'stroke-width': '0.5px' });
      speedoDisplay.speedTicksText = hu('#speedTicksText', speedoDisplay.speedometerText);
      speedoDisplay.gears.root = hu('#gears_layer', svg);
      speedoDisplay.gears.P = hu('#gearP', speedoDisplay.gears.root);
      speedoDisplay.gears.R = hu('#gearR', speedoDisplay.gears.root);
      speedoDisplay.gears.N = hu('#gearN', speedoDisplay.gears.root);
      speedoDisplay.gears.D = hu('#gearD', speedoDisplay.gears.root);
      speedoDisplay.gears.S = hu('#gearS', speedoDisplay.gears.root);
      speedoDisplay.gears.M = hu('#gearM', speedoDisplay.gears.root);
      speedoDisplay.gears.gearValue = hu('#gearValue', speedoDisplay.gears.root);
      speedoDisplay.gears.D.text("1");
      speedoDisplay.clock = hu('#clock', speedoDisplay.root);
      //speedoDisplay.gears.S = hu('#gearS', speedoDisplay.gears.root);
      speedoDisplay.needle = hu('#needle', speedoDisplay.root);
      //speedoDisplay.needle.css({transformOrigin: '68px 33px', transform: 'rotate(227deg)'}).attr({class: "fade-in"});
      //speedoDisplay.needle.attr({class: "fade-in"});
      speedoDisplay.needle_bar = hu('#needle_bar', speedoDisplay.root);
      //speedoDisplay.needle_bar.attr({class: "fade-in"});
      speedoDisplay.needle_gradients = [];
      speedoDisplay.needle_gradients.push(hu('#radialGradient965', svg));
      speedoDisplay.needle_lingradient = hu('#linearGradient1357', svg);
      speedoDisplay.needle_bar_highlight = hu('#needle_bar_highlight', speedoDisplay.root);
      speedoDisplay.needle_bar_highlightGrad = hu('#linearGradient1390', svg);

      // speedometer RS


      speedoDisplay.speedometerText.fuelValue_rs = hu('#fuelValue_rs', speedoDisplay.speedometerText.root);


      speedoDisplay.speedValue_rs = hu('#speedValue_rs', speedoDisplay.speedometerText);
      speedoDisplay.speedValue10_rs = hu('#speedValue_ab10kmh_rs', speedoDisplay.speedometerText);
      speedoDisplay.speedValue100_rs = hu('#speedValue_ab100kmh_rs', speedoDisplay.speedometerText);

      speedoDisplay.torque_module_rs_percent = hu('#torque_module_rs_percent', speedoDisplay.speedometerText);
      speedoDisplay.torque_module_rs_percent_10 = hu('#torque_module_rs_percent_10', speedoDisplay.speedometerText);
      speedoDisplay.torque_module_rs_percent_100 = hu('#torque_module_rs_percent_100', speedoDisplay.speedometerText);

      speedoDisplay.hp_module_rs_percent = hu('#hp_module_rs_percent', speedoDisplay.speedometerText);
      speedoDisplay.hp_module_rs_percent_10 = hu('#hp_module_rs_percent_10', speedoDisplay.speedometerText);
      speedoDisplay.hp_module_rs_percent_100 = hu('#hp_module_rs_percent_100', speedoDisplay.speedometerText);

      speedoDisplay.gears.P_rs = hu('#gearP_rs', speedoDisplay.gears.root);
      speedoDisplay.gears.R_rs = hu('#gearR_rs', speedoDisplay.gears.root);
      speedoDisplay.gears.N_rs = hu('#gearN_rs', speedoDisplay.gears.root);
      speedoDisplay.gears.D_rs = hu('#gearD_rs', speedoDisplay.gears.root);
      speedoDisplay.gears.S_rs = hu('#gearS_rs', speedoDisplay.gears.root);
      speedoDisplay.gears.MS = hu('#gearMS', speedoDisplay.gears.root);
      speedoDisplay.gears.gearValue_rs = hu('#gearValue_rs', speedoDisplay.gears.root);
      speedoDisplay.gears.gearValue_rs_ms = hu('#gearValue_rs_ms', speedoDisplay.gears.root);
      speedoDisplay.gears.D_rs.text("1");


      // drivemodes non-RS
      drivemodes.root = hu('#drivemodes', svg);
      drivemodes.mode_Comfort = hu('#drivemode_comfort', drivemodes.root);
      drivemodes.mode_Dynamic = hu('#drivemode_dynamic', drivemodes.root);


      // drivemodes RS
      drivemodes.mode_rs1 = hu('#drivemode_rs1', drivemodes.root);
      drivemodes.mode_rs2 = hu('#drivemode_rs2', drivemodes.root);

      // Background non-RS
      bg.root = hu('#bg', svg);
      bg.rpm_Tachometer_4000 = hu('#rpm_Tachometer_4000', bg.root);
      bg.rpm_Tachometer_6000 = hu('#rpm_Tachometer_6000', bg.root);
      bg.rpm_Tachometer_6500 = hu('#rpm_Tachometer_6500', bg.root);
      bg.kmh_Tachometer = hu('#kmh_Tachometer', bg.root);

      bg.gMeter = hu('#gMeter', bg.root);
      bg.gMeterUp = hu('#gMeter_Up', bg.root);
      bg.gMeterDown = hu('#gMeter_Down', bg.root);
      bg.gMeterLeft = hu('#gMeter_Left', bg.root);
      bg.gMeterRight = hu('#gMeter_Right', bg.root);
      bg.gMeterPoint = hu('#gMeter_Point', bg.root);
      bg.gMeterTitle = hu('#gMeter_title', bg.root);
      bg.gMeterTitlereset = hu('#gMeter_titlereset', bg.root);

      bg.headline_normal = hu('#headline_normal', bg.root);
      bg.underline_normal = hu('#underline_normal', bg.root);
      

      // Background RS

      bg.rpm_Tachometer_6500_rs = hu('#rpm_Tachometer_6500_rs', bg.root);
      bg.rpm_Tachometer_6000_rs = hu('#rpm_Tachometer_6000_rs', bg.root);
      bg.rpm_Tachometer_4000_rs = hu('#rpm_Tachometer_4000_rs', bg.root);

      bg.underline_rs = hu('#underline_rs', bg.root);
      bg.headline_rs = hu('#headline_rs', bg.root);
    
      bg.km_display_rs = hu('#km_display_rs', bg.root);
      bg.trip_display_rs = hu('#trip_display_rs', bg.root);

      bg.torque_module_rs = hu('#torque_module_rs', bg.root);
      bg.hp_module_rs = hu('#hp_module_rs', bg.root);

      bg.torque_module_rs_title = hu('#torque_module_rs_title', bg.root);
      bg.hp_module_rs_title = hu('#hp_module_rs_title', bg.root);

      bg.gMeter_rs = hu('#gMeter_rs', bg.root);
      bg.gMeterUp_rs = hu('#gMeter_Up_rs', bg.root);
      bg.gMeterDown_rs = hu('#gMeter_Down_rs', bg.root);
      bg.gMeterLeft_rs = hu('#gMeter_Left_rs', bg.root);
      bg.gMeterRight_rs = hu('#gMeter_Right_rs', bg.root);
      bg.gMeterPoint_rs = hu('#gMeter_Point_rs', bg.root);
      bg.gMeterTitle_rs = hu('#gMeter_title_rs', bg.root);
      bg.gMeterTitlereset_rs = hu('#gMeter_titlereset_rs', bg.root);

      bg.warning_background_rs = hu('#warning_background_rs', bg.root);
      bg.launch_control_title_rs = hu('#launch_control_title_rs', bg.root);

      bg.temperature_display_rs = hu('#temperature_display_rs', bg.root);
      bg.temperature_display_rs_bar = hu('#temperature_display_rs_bar', bg.root);
      bg.temperature_display_rs_symbol = hu('#temperature_display_rs_symbol', bg.root);
      bg.temperature_display_rs_temp = hu('#temperature_display_rs_temp', bg.root);

      bg.boost_display_rs = hu('#boost_display_rs', bg.root);
      bg.boost_display_rs_bar = hu('#boost_display_rs_bar', bg.root);
      bg.boost_display_rs_boosttitle = hu('#boost_display_rs_boosttitle', bg.root);
      bg.boost_display_rs_min = hu('#boost_display_rs_min', bg.root);
      bg.boost_display_rs_max = hu('#boost_display_rs_max', bg.root);

      bg.rpm_0 = hu('#rpm_0', bg.root);
      bg.rpm_250 = hu('#rpm_250', bg.root);
      bg.rpm_500 = hu('#rpm_500', bg.root);
      bg.rpm_750 = hu('#rpm_750', bg.root);
      bg.rpm_1000 = hu('#rpm_1000', bg.root);
      bg.rpm_1250 = hu('#rpm_1250', bg.root);
      bg.rpm_1500 = hu('#rpm_1500', bg.root);
      bg.rpm_1750 = hu('#rpm_1750', bg.root);
      bg.rpm_2000 = hu('#rpm_2000', bg.root);
      bg.rpm_2250 = hu('#rpm_2250', bg.root);
      bg.rpm_2500 = hu('#rpm_2500', bg.root);
      bg.rpm_2750 = hu('#rpm_2750', bg.root);
      bg.rpm_3000 = hu('#rpm_3000', bg.root);
      bg.rpm_3250 = hu('#rpm_3250', bg.root);
      bg.rpm_3500 = hu('#rpm_3500', bg.root);
      bg.rpm_3750 = hu('#rpm_3750', bg.root);
      bg.rpm_4000 = hu('#rpm_4000', bg.root);
      bg.rpm_4250 = hu('#rpm_4250', bg.root);
      bg.rpm_4500 = hu('#rpm_4500', bg.root);
      bg.rpm_4750 = hu('#rpm_4750', bg.root);
      bg.rpm_5000 = hu('#rpm_5000', bg.root);
      bg.rpm_5250 = hu('#rpm_5250', bg.root);
      bg.rpm_5500 = hu('#rpm_5500', bg.root);
      bg.rpm_5750 = hu('#rpm_5750', bg.root);
      bg.rpm_6000 = hu('#rpm_6000', bg.root);
      bg.rpm_6250 = hu('#rpm_6250', bg.root);
      bg.rpm_6500 = hu('#rpm_6500', bg.root);
      bg.rpm_6750 = hu('#rpm_6750', bg.root);
      bg.rpm_7000 = hu('#rpm_7000', bg.root);
      bg.rpm_7250 = hu('#rpm_7250', bg.root);
      bg.rpm_7500 = hu('#rpm_7500', bg.root);
      bg.rpm_7750 = hu('#rpm_7750', bg.root);
      bg.rpm_8000 = hu('#rpm_8000', bg.root);

      // Tacho non-RS
      tacho.root = hu('#tacho', svg);
      tacho.bar = hu('#rpm_needle_bar', tacho.root);
      tacho.needle = hu('#rpm_needle', tacho.root);
      tacho.Ticks = hu('#rpmTicks', tacho.root);
      tacho.Ticks.css({ 'stroke': `rgba(255, 255, 255, 0.5)`, 'stroke-width': '0.5px' });
      tacho.TicksText = hu('#rpmTicksText', tacho.root);
      tacho.needle_gradients = [];
      tacho.needle_gradients.push(hu('#radialGradient965-1', svg));
      tacho.needle_lingradient = hu('#linearGradient1369', svg);
      tacho.rpm_needle_bar_highlight = hu('#rpm_needle_bar_highlight', tacho.root);
      tacho.rpm_needle_bar_highlightGrad = hu('#linearGradient1392', svg);


      // Tacho RS


      tacho.shiftlight_5000 = hu('#shiftlight_5000', tacho.root);
      tacho.shiftlight_5500 = hu('#shiftlight_5500', tacho.root);
      tacho.shiftlight_6000 = hu('#shiftlight_6000', tacho.root);
      tacho.shiftlight_6500 = hu('#shiftlight_6500', tacho.root);
      tacho.shiftlight_7000 = hu('#shiftlight_7000', tacho.root);
      tacho.shiftlight_7500 = hu('#shiftlight_7500', tacho.root);

      tacho.needle_hp_module_rs = hu('#needle_hp_module_rs', tacho.root);
      tacho.needle_torque_module_rs = hu('#needle_torque_module_rs', tacho.root);



      gagues.root = hu('#gagues', svg);
      gagues.fuel.low = hu('#fuelBar1', gagues.root);
      gagues.fuel.normal = hu('#fuelBar2', gagues.root);

      gagues.temp.low = hu('#tempBar1', gagues.root);
      gagues.temp.normal = hu('#tempBar2', gagues.root);
      gagues.temp.high = hu('#tempBar3', gagues.root);

      // nav
      // navDisplay.root = hu('#navigation', svg);
      // navDisplay.overlay = hu('#MapOverlay', navDisplay.root);


      //speedoDisplay.speedometerText.attr({class: "grow"})
      // infoDisplay.root.attr({class: "slide-right"});
      // navDisplay.root.attr({class: "slide-left"});
      // var background = hu('#background', svg);
      // background.attr({class: 'map-fade'})


      // electrics non-RS
      electrics.root = hu('#lights_layer', svg);
      electrics.lights.signal_L = hu("#light_signal_L", electrics.root);
      electrics.lights.signal_R = hu("#light_signal_R", electrics.root);
      electrics.lights.lights = hu("#light_lights", electrics.root);
      electrics.lights.highbeam = hu("#light_highbeam", electrics.root);
      electrics.lights.fog = hu("#light_fog", electrics.root);
      electrics.lights.lowpressure = hu("#light_lowpressure", electrics.root);
      electrics.lights.parkingbrake = hu("#light_parkingbrake", electrics.root);
      electrics.lights.checkengine = hu("#light_checkengine", electrics.root);
      electrics.lights.hazard = hu("#light_hazard", electrics.root);
      electrics.lights.oil = hu("#light_oil", electrics.root);
      electrics.lights.cruiseControlActive = hu("#light_cruise", electrics.root);

      electrics.lights_battery = hu("#lights_battery", electrics.root);
      electrics.lights_fog_front = hu("#light_fog_front", electrics.root);
      electrics.esc = hu("#light_escActive", electrics.root);
      electrics.tcs = hu("#light_tcsActive", electrics.root);
      electrics.temp_logo = hu("#temp_logo", electrics.root);
      electrics.fuel_logo = hu("#fuel_logo", electrics.root);

      electrics.temp_env_txt = hu("#temp_txt", electrics.root);
      electrics.mode_txt = hu("#mode_txt", electrics.root);


      // electrics RS

      updateClock();

      ready = true;
    }

    function switchGauges(data) {


      if (rsTacho === true) {

        bg.rpm_Tachometer_6500.css({ display: "none" });
        bg.rpm_Tachometer_6000.css({ display: "none" });
        bg.rpm_Tachometer_4000.css({ display: "none" });

        bg.kmh_Tachometer.css({ display: "none" });

        bg.headline_normal.css({ display: "none" });
        bg.underline_normal.css({ display: "none" });

        bg.gMeter.css({ display: "none" });
        bg.gMeterUp.css({ display: "none" });
        bg.gMeterDown.css({ display: "none" });
        bg.gMeterLeft.css({ display: "none" });
        bg.gMeterRight.css({ display: "none" });
        bg.gMeterPoint.css({ display: "none" });
        bg.gMeterTitle.css({ display: "none" });
        bg.gMeterTitlereset.css({ display: "none" });

        tacho.needle.css({ display: "none" });

        speedoDisplay.needle.css({ display: "none" });
        speedoDisplay.speedValue.css({ display: "none" });
        speedoDisplay.speedValue10.css({ display: "none" });
        speedoDisplay.speedValue100.css({ display: "none" });

        speedoDisplay.speedometerText.fuelValue.css({ display: "none" });

        speedoDisplay.gears["P"].css({ "display": "none" });
        speedoDisplay.gears["R"].css({ "display": "none" });
        speedoDisplay.gears["N"].css({ "display": "none" });
        speedoDisplay.gears["D"].css({ "display": "none" });
        speedoDisplay.gears["S"].css({ "display": "none" });
        speedoDisplay.gears["M"].css({ "display": "none" });
        speedoDisplay.gears.gearValue.text(null);
        speedoDisplay.gears.gearValue.css({ "display": "none" });

        getRPM(data);

        if (data.electrics.gear.startsWith("M")) {
          speedoDisplay.gears["P_rs"].css({ "display": "none" });
          speedoDisplay.gears["R_rs"].css({ "display": "none" });
          speedoDisplay.gears["N_rs"].css({ "display": "none" });
          speedoDisplay.gears["D_rs"].css({ "display": "none" });
          speedoDisplay.gears["S_rs"].css({ "display": "none" });
          speedoDisplay.gears["MS"].css({ "display": "block" });
          speedoDisplay.gears.gearValue_rs.css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs_ms.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue_rs_ms.css({ "display": "block" });
        }
        if (data.electrics.gear.startsWith("S")) {
          speedoDisplay.gears["P_rs"].css({ "display": "none" });
          speedoDisplay.gears["R_rs"].css({ "display": "none" });
          speedoDisplay.gears["N_rs"].css({ "display": "none" });
          speedoDisplay.gears["D_rs"].css({ "display": "none" });
          speedoDisplay.gears["S_rs"].css({ "display": "block" });
          speedoDisplay.gears["MS"].css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs_ms.css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue_rs.css({ "display": "block" });
        }
        if (data.electrics.gear.startsWith("P")) {
          speedoDisplay.gears["P_rs"].css({ "display": "block" });
          speedoDisplay.gears["R_rs"].css({ "display": "none" });
          speedoDisplay.gears["N_rs"].css({ "display": "none" });
          speedoDisplay.gears["D_rs"].css({ "display": "none" });
          speedoDisplay.gears["S_rs"].css({ "display": "none" });
          speedoDisplay.gears["MS"].css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs_ms.css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue_rs.css({ "display": "none" });
        }
        if (data.electrics.gear.startsWith("N")) {
          speedoDisplay.gears["P_rs"].css({ "display": "none" });
          speedoDisplay.gears["R_rs"].css({ "display": "none" });
          speedoDisplay.gears["N_rs"].css({ "display": "block" });
          speedoDisplay.gears["D_rs"].css({ "display": "none" });
          speedoDisplay.gears["S_rs"].css({ "display": "none" });
          speedoDisplay.gears["MS"].css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs_ms.css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue_rs.css({ "display": "none" });
        }
        if (data.electrics.gear.startsWith("R")) {
          speedoDisplay.gears["P_rs"].css({ "display": "none" });
          speedoDisplay.gears["R_rs"].css({ "display": "block" });
          speedoDisplay.gears["N_rs"].css({ "display": "none" });
          speedoDisplay.gears["D_rs"].css({ "display": "none" });
          speedoDisplay.gears["S_rs"].css({ "display": "none" });
          speedoDisplay.gears["MS"].css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs_ms.css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue_rs.css({ "display": "none" });
        }
        if (data.electrics.gear.startsWith("D")) {
          speedoDisplay.gears["P_rs"].css({ "display": "none" });
          speedoDisplay.gears["R_rs"].css({ "display": "none" });
          speedoDisplay.gears["N_rs"].css({ "display": "none" });
          speedoDisplay.gears["D_rs"].css({ "display": "block" });
          speedoDisplay.gears["S_rs"].css({ "display": "none" });
          speedoDisplay.gears["MS"].css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs_ms.css({ "display": "none" });
          speedoDisplay.gears.gearValue_rs.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue_rs.css({ "display": "none" });
        }

        bg.underline_normal.css({ display: "none" });


        bg.underline_rs.css({ display: "block" });
        bg.headline_rs.css({ display: "block" });

        bg.torque_module_rs.css({ display: "block" });
        bg.hp_module_rs.css({ display: "block" });

        bg.torque_module_rs_title.css({ display: "block" });
        bg.hp_module_rs_title.css({ display: "block" });

        bg.gMeter_rs.css({ display: "block" });
        bg.gMeterUp_rs.css({ display: "block" });
        bg.gMeterDown_rs.css({ display: "block" });
        bg.gMeterLeft_rs.css({ display: "block" });
        bg.gMeterRight_rs.css({ display: "block" });
        bg.gMeterPoint_rs.css({ display: "block" });
        bg.gMeterTitle_rs.css({ display: "block" });
        bg.gMeterTitlereset_rs.css({ display: "block" });

        bg.temperature_display_rs.css({ display: "block" });
        bg.temperature_display_rs_bar.css({ display: "block" });
        bg.temperature_display_rs_symbol.css({ display: "block" });
        bg.temperature_display_rs_temp.css({ display: "block" });
        bg.boost_display_rs.css({ display: "block" });
        bg.boost_display_rs_bar.css({ display: "block" });
        bg.boost_display_rs_boosttitle.css({ display: "block" });
        bg.boost_display_rs_min.css({ display: "block" });
        bg.boost_display_rs_max.css({ display: "block" });

        
        bg.km_display_rs.css({ display: "block" });
        bg.trip_display_rs.css({ display: "block" });

        speedoDisplay.speedometerText.fuelValue_rs.css({ display: "block" });

      } else {

        bg.rpm_Tachometer_6500_rs.css({ display: "none" });
        bg.rpm_Tachometer_6000_rs.css({ display: "none" });
        bg.rpm_Tachometer_4000_rs.css({ display: "none" });

        tacho.shiftlight_5000.css({ display: "none" });
        tacho.shiftlight_5500.css({ display: "none" });
        tacho.shiftlight_6000.css({ display: "none" });
        tacho.shiftlight_6500.css({ display: "none" });
        tacho.shiftlight_7000.css({ display: "none" });
        tacho.shiftlight_7500.css({ display: "none" });


        speedoDisplay.gears["P_rs"].css({ "display": "none" });
        speedoDisplay.gears["R_rs"].css({ "display": "none" });
        speedoDisplay.gears["N_rs"].css({ "display": "none" });
        speedoDisplay.gears["D_rs"].css({ "display": "none" });
        speedoDisplay.gears["S_rs"].css({ "display": "none" });
        speedoDisplay.gears["MS"].css({ "display": "none" });
        speedoDisplay.gears.gearValue_rs_ms.css({ "display": "none" });
        speedoDisplay.gears.gearValue_rs.text(null);
        speedoDisplay.gears.gearValue_rs.css({ "display": "none" });


        bg.rpm_0.css({ display: "none" });
        bg.rpm_250.css({ display: "none" });
        bg.rpm_500.css({ display: "none" });
        bg.rpm_750.css({ display: "none" });
        bg.rpm_1000.css({ display: "none" });
        bg.rpm_1250.css({ display: "none" });
        bg.rpm_1500.css({ display: "none" });
        bg.rpm_1750.css({ display: "none" });
        bg.rpm_2000.css({ display: "none" });
        bg.rpm_2250.css({ display: "none" });
        bg.rpm_2500.css({ display: "none" });

        bg.rpm_2750.css({ display: "none" });
        bg.rpm_3000.css({ display: "none" });
        bg.rpm_3250.css({ display: "none" });
        bg.rpm_3500.css({ display: "none" });
        bg.rpm_3750.css({ display: "none" });
        bg.rpm_4000.css({ display: "none" });
        bg.rpm_4250.css({ display: "none" });
        bg.rpm_4500.css({ display: "none" });
        bg.rpm_4750.css({ display: "none" });
        bg.rpm_5000.css({ display: "none" });
        bg.rpm_5250.css({ display: "none" });
        bg.rpm_5500.css({ display: "none" });
        bg.rpm_5750.css({ display: "none" });
        bg.rpm_6000.css({ display: "none" });

        bg.rpm_6250.css({ display: "none" });
        bg.rpm_6500.css({ display: "none" });
        bg.rpm_6750.css({ display: "none" });
        bg.rpm_7000.css({ display: "none" });
        bg.rpm_7250.css({ display: "none" });
        bg.rpm_7500.css({ display: "none" });
        bg.rpm_7750.css({ display: "none" });
        bg.rpm_8000.css({ display: "none" });


        getRPM(data);

        bg.kmh_Tachometer.css({ display: "block" });

        bg.underline_rs.css({ display: "none" });
        bg.headline_rs.css({ display: "none" });

        bg.headline_normal.css({ display: "block" });
        bg.underline_normal.css({ display: "block" });

        bg.torque_module_rs.css({ display: "none" });
        bg.hp_module_rs.css({ display: "none" });

        bg.torque_module_rs_title.css({ display: "none" });
        bg.hp_module_rs_title.css({ display: "none" });

        bg.warning_background_rs.css({ display: "none" });
        bg.launch_control_title_rs.css({ display: "none" });

        speedoDisplay.torque_module_rs_percent.css({ display: "none" });
        speedoDisplay.torque_module_rs_percent_10.css({ display: "none" });
        speedoDisplay.torque_module_rs_percent_100.css({ display: "none" });

        speedoDisplay.hp_module_rs_percent.css({ display: "none" });
        speedoDisplay.hp_module_rs_percent_10.css({ display: "none" });
        speedoDisplay.hp_module_rs_percent_100.css({ display: "none" });

        bg.temperature_display_rs.css({ display: "none" });
        bg.temperature_display_rs_bar.css({ display: "none" });
        bg.temperature_display_rs_symbol.css({ display: "none" });
        bg.temperature_display_rs_temp.css({ display: "none" });
        bg.boost_display_rs.css({ display: "none" });
        bg.boost_display_rs_bar.css({ display: "none" });
        bg.boost_display_rs_boosttitle.css({ display: "none" });
        bg.boost_display_rs_min.css({ display: "none" });
        bg.boost_display_rs_max.css({ display: "none" });

        
        bg.km_display_rs.css({ display: "none" });
        bg.trip_display_rs.css({ display: "none" });

        bg.gMeter.css({ display: "block" });
        bg.gMeterUp.css({ display: "block" });
        bg.gMeterDown.css({ display: "block" });
        bg.gMeterLeft.css({ display: "block" });
        bg.gMeterRight.css({ display: "block" });
        bg.gMeterPoint.css({ display: "block" });
        bg.gMeterTitle.css({ display: "block" });
        bg.gMeterTitlereset.css({ display: "block" });

        bg.gMeter_rs.css({ display: "none" });
        bg.gMeterUp_rs.css({ display: "none" });
        bg.gMeterDown_rs.css({ display: "none" });
        bg.gMeterLeft_rs.css({ display: "none" });
        bg.gMeterRight_rs.css({ display: "none" });
        bg.gMeterPoint_rs.css({ display: "none" });
        bg.gMeterTitle_rs.css({ display: "none" });
        bg.gMeterTitlereset_rs.css({ display: "none" });



        tacho.needle.css({ display: "block" });

        speedoDisplay.needle.css({ display: "block" });

        speedoDisplay.speedometerText.fuelValue.css({ display: "block" });


        speedoDisplay.speedometerText.fuelValue_rs.css({ display: "none" });


        if (data.electrics.gear.startsWith("M")) {
          speedoDisplay.gears["P"].css({ "display": "none" });
          speedoDisplay.gears["R"].css({ "display": "none" });
          speedoDisplay.gears["N"].css({ "display": "none" });
          speedoDisplay.gears["D"].css({ "display": "none" });
          speedoDisplay.gears["S"].css({ "display": "none" });
          speedoDisplay.gears["M"].css({ "display": "block" });
          speedoDisplay.gears.gearValue.css({ "display": "none" });
          speedoDisplay.gears.gearValue.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue.css({ "display": "block" });
        }
        if (data.electrics.gear.startsWith("S")) {
          speedoDisplay.gears["P"].css({ "display": "none" });
          speedoDisplay.gears["R"].css({ "display": "none" });
          speedoDisplay.gears["N"].css({ "display": "none" });
          speedoDisplay.gears["D"].css({ "display": "none" });
          speedoDisplay.gears["S"].css({ "display": "block" });
          speedoDisplay.gears["M"].css({ "display": "none" });
          speedoDisplay.gears.gearValue.css({ "display": "none" });
          speedoDisplay.gears.gearValue.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue.css({ "display": "block" });
        }
        if (data.electrics.gear.startsWith("P")) {
          speedoDisplay.gears["P"].css({ "display": "block" });
          speedoDisplay.gears["R"].css({ "display": "none" });
          speedoDisplay.gears["N"].css({ "display": "none" });
          speedoDisplay.gears["D"].css({ "display": "none" });
          speedoDisplay.gears["S"].css({ "display": "none" });
          speedoDisplay.gears["M"].css({ "display": "none" });
          speedoDisplay.gears.gearValue.css({ "display": "none" });
          speedoDisplay.gears.gearValue.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue.css({ "display": "none" });
        }
        if (data.electrics.gear.startsWith("N")) {
          speedoDisplay.gears["P"].css({ "display": "none" });
          speedoDisplay.gears["R"].css({ "display": "none" });
          speedoDisplay.gears["N"].css({ "display": "block" });
          speedoDisplay.gears["D"].css({ "display": "none" });
          speedoDisplay.gears["S"].css({ "display": "none" });
          speedoDisplay.gears["M"].css({ "display": "none" });
          speedoDisplay.gears.gearValue.css({ "display": "none" });
          speedoDisplay.gears.gearValue.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue.css({ "display": "none" });
        }
        if (data.electrics.gear.startsWith("R")) {
          speedoDisplay.gears["P"].css({ "display": "none" });
          speedoDisplay.gears["R"].css({ "display": "block" });
          speedoDisplay.gears["N"].css({ "display": "none" });
          speedoDisplay.gears["D"].css({ "display": "none" });
          speedoDisplay.gears["S"].css({ "display": "none" });
          speedoDisplay.gears["M"].css({ "display": "none" });
          speedoDisplay.gears.gearValue.css({ "display": "none" });
          speedoDisplay.gears.gearValue.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue.css({ "display": "none" });
        }
        if (data.electrics.gear.startsWith("D")) {
          speedoDisplay.gears["P"].css({ "display": "none" });
          speedoDisplay.gears["R"].css({ "display": "none" });
          speedoDisplay.gears["N"].css({ "display": "none" });
          speedoDisplay.gears["D"].css({ "display": "block" });
          speedoDisplay.gears["S"].css({ "display": "none" });
          speedoDisplay.gears["M"].css({ "display": "none" });
          speedoDisplay.gears.gearValue.css({ "display": "none" });
          speedoDisplay.gears.gearValue.text(currentGear.replace('M', '').replace('S', ''));
          speedoDisplay.gears.gearValue.css({ "display": "none" });
        }


      }

    }


    function updateGearIndicator(data) {
      // only update when gear is changed
      if (currentGear !== data.electrics.gear) {
        currentGear = data.electrics.gear;
        var xct = 0;
        if (isNaN(data.electrics.gear)) {//auto,DCT
          if (rsTacho === false) {
            //speedoDisplay.gears["P"].n.style.display = "inline"; //because why not at this point
            if (currentGear.startsWith("M")) {
              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "block" });
              speedoDisplay.gears.gearValue.text(currentGear.replace('M', '').replace('S', ''));
              speedoDisplay.gears.gearValue.css({ "display": "block" });

            }
            if (currentGear.startsWith("D")) {
              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "block" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.css({ "display": "none" });

            }
            if (currentGear.startsWith("P")) {
              speedoDisplay.gears["P"].css({ "display": "block" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.css({ "display": "none" });

            }
            if (currentGear.startsWith("N")) {
              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "block" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.css({ "display": "none" });

            }
            if (currentGear.startsWith("R")) {

              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "block" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.css({ "display": "none" });

            }
            if (currentGear.startsWith("S")) {
              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "block" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.text(currentGear.replace('M', '').replace('S', ''));
              speedoDisplay.gears.gearValue.css({ "display": "block" });

            }
          } else {

            if (currentGear.startsWith("M")) {
              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.text(currentGear.replace('M', '').replace('S', ''));
              speedoDisplay.gears.gearValue.css({ "display": "block" });

            }
            if (currentGear.startsWith("D")) {
              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.css({ "display": "none" });

            }
            if (currentGear.startsWith("P")) {
              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.css({ "display": "none" });

            }
            if (currentGear.startsWith("N")) {
              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.css({ "display": "none" });

            }
            if (currentGear.startsWith("R")) {

              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.css({ "display": "none" });

            }
            if (currentGear.startsWith("S")) {
              speedoDisplay.gears["P"].css({ "display": "none" });
              speedoDisplay.gears["R"].css({ "display": "none" });
              speedoDisplay.gears["N"].css({ "display": "none" });
              speedoDisplay.gears["D"].css({ "display": "none" });
              speedoDisplay.gears["S"].css({ "display": "none" });
              speedoDisplay.gears["M"].css({ "display": "none" });
              speedoDisplay.gears.gearValue.text(currentGear.replace('M', '').replace('S', ''));
              speedoDisplay.gears.gearValue.css({ "display": "block" });

            }

          }
        } else {//manuel
          speedoDisplay.gears["P"].n.style.display = "none";
          switch (data.electrics.gear) {
            case -1:
              speedoDisplay.gears["R"].css({ fill: '#FFFFFF', "font-size": "12px", "transform": "translate(-4px, 0px)" });
              speedoDisplay.gears["N"].css({ fill: '#616161', "font-size": "6.35px", "transform": "translate(0px, 0px)" });
              speedoDisplay.gears["D"].css({ fill: '#616161', "font-size": "6.35px", "transform": "translate(0px, 0px)" }).text("1");
              break;
            case 0:
              speedoDisplay.gears["R"].css({ fill: '#616161', "font-size": "6.35px", "transform": "translate(-4px, 0px)" });
              speedoDisplay.gears["N"].css({ fill: '#FFFFFF', "font-size": "12px", "transform": "translate(-4px, 0px)" });
              speedoDisplay.gears["D"].css({ fill: '#616161', "font-size": "6.35px", "transform": "translate(1px, 0px)" });//.text("1");
              break;
            default:
              speedoDisplay.gears["R"].css({ fill: '#616161', "font-size": "6.35px", "transform": "translate(-4px, 0px)" });
              speedoDisplay.gears["N"].css({ fill: '#616161', "font-size": "6.35px", "transform": "translate(-4px, 0px)" });
              speedoDisplay.gears["D"].css({ fill: '#FFFFFF', "font-size": "12px", "transform": "translate(-4px, 0px)" }).text(data.electrics.gear);
              break;
          }

        }

      }
    }


    function updateSpeedDisplays(data) {
      if (speedoInitialised) {
        if (rsTacho === false) {


          speedoDisplay.speedValue_rs.css({ "display": "none" });
          speedoDisplay.speedValue10_rs.css({ "display": "none" });
          speedoDisplay.speedValue100_rs.css({ "display": "none" });

          var speedAng = 260 + ((data.electrics.wheelspeed * 3.6));
          var startAngle = 150 * Math.PI / 180, speedRad = (data.electrics.wheelspeed * 0.0735) + startAngle;          
		  if (data.electrics.wheelspeed * 3.6 >= 113) {
            startAngle = 210 * Math.PI / 180
            speedRad = (data.electrics.wheelspeed * 0.041) + startAngle;
          }
		  if (data.electrics.wheelspeed * 3.6 >= 204) {
            startAngle = 222 * Math.PI / 180
            speedRad = (data.electrics.wheelspeed * 0.037) + startAngle;
          }
          var maxRad = (260 * Math.PI / 180) + startAngle;
          speedRad = Math.min(speedRad, maxRad);
          //console.log("maxRad",maxRad,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad-startAngle)*180/Math.PI);



          if (data.electrics.wheelspeed * 3.6 < 10) {

            speedoDisplay.speedValue.css({ "display": "block" });
            speedoDisplay.speedValue10.css({ "display": "none" });
            speedoDisplay.speedValue100.css({ "display": "none" });

            speedoDisplay.speedValue.text((data.electrics.wheelspeed * unitspeedConv).toFixed(0));

          } else if (data.electrics.wheelspeed * 3.6 > 9 && data.electrics.wheelspeed * 3.6 < 100) {
            speedoDisplay.speedValue.css({ "display": "none" });
            speedoDisplay.speedValue10.css({ "display": "block" });
            speedoDisplay.speedValue100.css({ "display": "none" });

            speedoDisplay.speedValue10.text((data.electrics.wheelspeed * unitspeedConv).toFixed(0));

          } else if (data.electrics.wheelspeed * 3.6 > 99) {
            speedoDisplay.speedValue.css({ "display": "none" });
            speedoDisplay.speedValue10.css({ "display": "none" });
            speedoDisplay.speedValue100.css({ "display": "block" });

            speedoDisplay.speedValue100.text((data.electrics.wheelspeed * unitspeedConv).toFixed(0));

          }
          if (Math.abs(speedRad - cachedAng.speedo) < refreshAng) { return; }
          cachedAng.speedo = speedRad;

          var centerX = 185.5, centerY = 37.4, radiusInt = 14, radiusExt = 24, largeArcFlag = ((speedRad - startAngle) > Math.PI) ? 0 : 0, radiusExtH = radiusExt - 1;
          //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);
          var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
          var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

          var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

          var ex2 = (centerX) + Math.cos(speedRad) * radiusExt;
          var ey2 = (centerY) + Math.sin(speedRad) * radiusExt;

          var ex1 = (centerX) + Math.cos(speedRad) * radiusInt;
          var ey1 = (centerY) + Math.sin(speedRad) * radiusInt;

          var mx1 = (centerX) + Math.cos(speedRad) * 0;
          var my1 = (centerY) + Math.sin(speedRad) * 0;

          /*speedoDisplay.needle_bar.attr({d: "M " + sx1 + "," + sy1 +
            " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
            " L " + ex1 + "," + ey1 /*+
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2*///});
          speedoDisplay.needle.attr({ d: "M " + ex1 + "," + ey1 + " " + ex2 + "," + ey2 });
          //speedoDisplay.needle_lingradient.attr({x1: ex1, y1: ey1, x2: ex2, y2: ey2});


          ex2 = (centerX) + Math.cos(speedRad) * radiusExtH;
          ey2 = (centerY) + Math.sin(speedRad) * radiusExtH;

          ex1 = (centerX) + Math.cos(startAngle) * radiusExtH;
          ey1 = (centerY) + Math.sin(startAngle) * radiusExtH;
          /*speedoDisplay.needle_bar_highlight.attr({d: "M " + ex1 + "," + ey1 +
          " A" + radiusExtH  + "," + radiusExtH  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2});
          speedoDisplay.needle_bar_highlightGrad.attr({x1: ex1, y1: ey1, x2: ex2, y2: ey2});
  
  
          /*for(var E in speedoDisplay.needle_gradients){
            //console.log(speedoDisplay.needle_gradients[E].n.gradientTransform, typeof(speedoDisplay.needle_gradients[E].n.gradientTransform));
            speedoDisplay.needle_gradients[E].n.gradientTransform.baseVal[0].matrix.e = ex2;
            speedoDisplay.needle_gradients[E].n.gradientTransform.baseVal[0].matrix.f = ey2;
            //speedoDisplay.needle_gradients[E].attr({cx:40,cy:40,fx:0,fy:0});
          }*/
        } else {
          speedoDisplay.speedValue.css({ "display": "none" });
          speedoDisplay.speedValue10.css({ "display": "none" });
          speedoDisplay.speedValue100.css({ "display": "none" });


          speedoDisplay.torque_module_rs_percent.css({ "display": "none" });
          speedoDisplay.torque_module_rs_percent_10.css({ "display": "none" });
          speedoDisplay.torque_module_rs_percent_100.css({ "display": "none" });


          speedoDisplay.hp_module_rs_percent.css({ "display": "none" });
          speedoDisplay.hp_module_rs_percent_10.css({ "display": "none" });
          speedoDisplay.hp_module_rs_percent_100.css({ "display": "none" });

          if (data.electrics.wheelspeed * 3.6 < 10) {

            speedoDisplay.speedValue_rs.css({ "display": "block" });
            speedoDisplay.speedValue10_rs.css({ "display": "none" });
            speedoDisplay.speedValue100_rs.css({ "display": "none" });

            speedoDisplay.speedValue_rs.text((data.electrics.wheelspeed * unitspeedConv).toFixed(0));

          } else if (data.electrics.wheelspeed * 3.6 > 9 && data.electrics.wheelspeed * 3.6 < 100) {
            speedoDisplay.speedValue_rs.css({ "display": "none" });
            speedoDisplay.speedValue10_rs.css({ "display": "block" });
            speedoDisplay.speedValue100_rs.css({ "display": "none" });

            speedoDisplay.speedValue10_rs.text((data.electrics.wheelspeed * unitspeedConv).toFixed(0));

          } else if (data.electrics.wheelspeed * 3.6 > 99) {
            speedoDisplay.speedValue_rs.css({ "display": "none" });
            speedoDisplay.speedValue10_rs.css({ "display": "none" });
            speedoDisplay.speedValue100_rs.css({ "display": "block" });

            speedoDisplay.speedValue100_rs.text((data.electrics.wheelspeed * unitspeedConv).toFixed(0));

          }



          if (data.drivetrain.engineLoad * 100 < 10) {
            speedoDisplay.hp_module_rs_percent.css({ "display": "block" });
            speedoDisplay.hp_module_rs_percent_10.css({ "display": "none" });
            speedoDisplay.hp_module_rs_percent_100.css({ "display": "none" });

            if (data.electrics.wheelspeed * 3.6 < 1 && data["electrics"]["rpmTacho"] < 1300) {
              speedoDisplay.hp_module_rs_percent.text("0");
            } else {
              speedoDisplay.hp_module_rs_percent.text((data.drivetrain.engineLoad * 100).toFixed(0));
            }

          } else if (data.drivetrain.engineLoad * 100 > 9 && data.drivetrain.engineLoad * 100 < 100) {
            speedoDisplay.hp_module_rs_percent.css({ "display": "none" });
            speedoDisplay.hp_module_rs_percent_10.css({ "display": "block" });
            speedoDisplay.hp_module_rs_percent_100.css({ "display": "none" });
            if (data.electrics.wheelspeed * 3.6 < 1) {
              speedoDisplay.hp_module_rs_percent.css({ "display": "block" });
              speedoDisplay.hp_module_rs_percent_10.css({ "display": "none" });
              speedoDisplay.hp_module_rs_percent_100.css({ "display": "none" });
              speedoDisplay.hp_module_rs_percent.text("0");
            } else {
              speedoDisplay.hp_module_rs_percent_10.text((data.drivetrain.engineLoad * 100).toFixed(0));
            }
          } else if (data.drivetrain.engineLoad * 100 > 99) {
            speedoDisplay.hp_module_rs_percent.css({ "display": "none" });
            speedoDisplay.hp_module_rs_percent_10.css({ "display": "none" });
            speedoDisplay.hp_module_rs_percent_100.css({ "display": "block" });
            if (data.electrics.wheelspeed * 3.6 < 1) {
              speedoDisplay.hp_module_rs_percent.css({ "display": "block" });
              speedoDisplay.hp_module_rs_percent_10.css({ "display": "none" });
              speedoDisplay.hp_module_rs_percent_100.css({ "display": "none" });
              speedoDisplay.hp_module_rs_percent.text("0");
            } else {
              speedoDisplay.hp_module_rs_percent_100.text((data.drivetrain.engineLoad * 100).toFixed(0));
            }
          }

          var torque = data.drivetrain.torqueTransmission;
          var torqueInPercent = (torque / 6);


          if (torqueInPercent <= 0 || data.electrics.wheelspeed * 3.6 < 1 && data["electrics"]["rpmTacho"] < 1300) {
            speedoDisplay.torque_module_rs_percent.css({ "display": "block" });
            speedoDisplay.torque_module_rs_percent_10.css({ "display": "none" });
            speedoDisplay.torque_module_rs_percent_100.css({ "display": "none" });

            speedoDisplay.torque_module_rs_percent.text("0");
          }

          if (torqueInPercent < 10 && torqueInPercent > 0) {


            speedoDisplay.torque_module_rs_percent.css({ "display": "block" });
            speedoDisplay.torque_module_rs_percent_10.css({ "display": "none" });
            speedoDisplay.torque_module_rs_percent_100.css({ "display": "none" });

            if (data.electrics.wheelspeed * 3.6 < 1) {
              speedoDisplay.torque_module_rs_percent.text("0");
            } else {
              speedoDisplay.torque_module_rs_percent.text((torqueInPercent).toFixed(0));
            }


          } else if (torqueInPercent > 9 && torqueInPercent < 100) {
            speedoDisplay.torque_module_rs_percent.css({ "display": "none" });
            speedoDisplay.torque_module_rs_percent_10.css({ "display": "block" });
            speedoDisplay.torque_module_rs_percent_100.css({ "display": "none" });

            if (data.electrics.wheelspeed * 3.6 < 1) {
              speedoDisplay.torque_module_rs_percent.text("0");
              speedoDisplay.torque_module_rs_percent.css({ "display": "block" });
              speedoDisplay.torque_module_rs_percent_10.css({ "display": "none" });
              speedoDisplay.torque_module_rs_percent_100.css({ "display": "none" });
            } else {
              speedoDisplay.torque_module_rs_percent_10.text((torqueInPercent).toFixed(0));
            }

          } else if (torqueInPercent >= 100) {
            speedoDisplay.torque_module_rs_percent.css({ "display": "none" });
            speedoDisplay.torque_module_rs_percent_10.css({ "display": "none" });
            speedoDisplay.torque_module_rs_percent_100.css({ "display": "block" });

            if (data.electrics.wheelspeed * 3.6 < 1) {
              speedoDisplay.torque_module_rs_percent.text("0");
              speedoDisplay.torque_module_rs_percent.css({ "display": "block" });
              speedoDisplay.torque_module_rs_percent_10.css({ "display": "none" });
              speedoDisplay.torque_module_rs_percent_100.css({ "display": "none" });
            } else {
              speedoDisplay.torque_module_rs_percent_100.text("100");
            }

          }

          if (data.electrics.wheelspeed * 3.6 < 1 && data["electrics"]["rpmTacho"] < 1300) {
            bg.boost_display_rs_bar.css({ width: `0px` });
          } else {

            bg.boost_display_rs_bar.css({ width: `${data.drivetrain.engineLoad * 24}px` });
          }

          if(data["electrics"]["watertemp"] < 50) {
            bg.temperature_display_rs_bar.css({width: `0px`});
          } else {
            bg.temperature_display_rs_bar.css({width: `${data["electrics"]["watertemp"].toFixed(0)/3.7-12.8}px`});
          }

          bg.temperature_display_rs_temp.text(data["electrics"]["watertemp"].toFixed(0) + "°C");



          bg.warning_background_rs.css({ display: "none" });
          bg.launch_control_title_rs.css({ display: "none" });

          if (data["electrics"]["rpmTacho"] > 2000 && data.electrics.wheelspeed < 1 && data.electrics.gear.startsWith("S")) {
            if (!bg.warning_background_rs.n.classList.contains("fade-in")) {
              bg.warning_background_rs.n.classList.add("fade-in");
            }
            if (!bg.launch_control_title_rs.n.classList.contains("fade-in")) {
              bg.launch_control_title_rs.n.classList.add("fade-in");
            }
            bg.warning_background_rs.css({ display: "inline" });
            bg.launch_control_title_rs.css({ display: "inline" });
          }
          if (data["electrics"]["rpmTacho"] > 2000 && data.electrics.wheelspeed < 1 && data.electrics.gear.startsWith("M")) {
            if (!bg.warning_background_rs.n.classList.contains("fade-in")) {
              bg.warning_background_rs.n.classList.add("fade-in");
            }
            if (!bg.launch_control_title_rs.n.classList.contains("fade-in")) {
              bg.launch_control_title_rs.n.classList.add("fade-in");
            }
            bg.warning_background_rs.css({ display: "inline" });
            bg.launch_control_title_rs.css({ display: "inline" });
          }


        }

      }
    }



    function updateTachoDisplays(data) {
      if (speedoInitialised) {
        if (rsTacho === false) {
          var speedAng = 270 + ((data["electrics"]["rpmTacho"] * 2.35));
          var startAngle = 147 * Math.PI / 180, speedRad = (data["electrics"]["rpmTacho"] * rpmRatio) + startAngle;
          var maxRad = (270 * Math.PI / 180) + startAngle;
          speedRad = Math.min(speedRad, maxRad);
          if (Math.abs(speedRad - cachedAng.tacho) < refreshAng) { return; }
          cachedAng.tacho = speedRad;
          //console.log("maxRad",maxRad,"start",startAngle,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad-startAngle)*180/Math.PI);



          //console.log(data["electrics"]["fuel"]/2*100);

          getRPM(data);

          var centerX = 84.6, centerY = 37.4, radiusInt = 14, radiusExt = 24, largeArcFlag = ((speedRad - startAngle) > Math.PI) ? 0 : 0, radiusExtH = radiusExt - 1;
          //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);
          var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
          var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

          var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

          var ex2 = (centerX) + Math.cos(speedRad) * radiusExt;
          var ey2 = (centerY) + Math.sin(speedRad) * radiusExt;

          var ex1 = (centerX) + Math.cos(speedRad) * radiusInt;
          var ey1 = (centerY) + Math.sin(speedRad) * radiusInt;

          var mx1 = (centerX) + Math.cos(speedRad) * 20;
          var my1 = (centerY) + Math.sin(speedRad) * 20;

          // Die Fuellung, die nach der Tachonadel kommt!!!
          /*tacho.bar.attr({
            d: "M " + sx1 + "," + sy1 +
              " A" + radiusExt + "," + radiusExt + " 0 " + largeArcFlag + ",1 " + ex2 + "," + ey2 +
              " L " + ex1 + "," + ey1 +
              " A" + radiusInt + "," + radiusInt + " 0 " + largeArcFlag + ",0 " + sx2 + "," + sy2
          });*/


          // Die Tachonadel!!!
          tacho.needle.attr({ d: "M " + ex1 + "," + ey1 + " " + ex2 + "," + ey2 });

          //tacho.needle_lingradient.attr({x1: ex1, y1: ey1, x2: ex2, y2: ey2});

          ex2 = (centerX) + Math.cos(speedRad) * radiusExtH;
          ey2 = (centerY) + Math.sin(speedRad) * radiusExtH;

          ex1 = (centerX) + Math.cos(startAngle) * radiusExtH;
          ey1 = (centerY) + Math.sin(startAngle) * radiusExtH;
          /*tacho.rpm_needle_bar_highlight.attr({
            d: "M " + ex1 + "," + ey1 +
              " A" + radiusExtH + "," + radiusExtH + " 0 " + largeArcFlag + ",0 " + ex2 + "," + ey2
          });
          tacho.rpm_needle_bar_highlightGrad.attr({ x1: ex1, y1: ey1, x2: ex2, y2: ey2 });*/

          for (var E in tacho.needle_gradients) {
            //tacho.needle_gradients[E].n.gradientTransform.baseVal[0].matrix.e = ex2;
            //tacho.needle_gradients[E].n.gradientTransform.baseVal[0].matrix.f = ey2;
          }
        } else {

          var rpm = data["electrics"]["rpmTacho"];

          //console.log(data.drivetrain.torqueTransmission / 4);

          if (rpm < 1) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "none" });
            bg.rpm_500.css({ display: "none" });
            bg.rpm_750.css({ display: "none" });
            bg.rpm_1000.css({ display: "none" });
            bg.rpm_1250.css({ display: "none" });
            bg.rpm_1500.css({ display: "none" });
            bg.rpm_1750.css({ display: "none" });
            bg.rpm_2000.css({ display: "none" });
            bg.rpm_2250.css({ display: "none" });
            bg.rpm_2500.css({ display: "none" });

            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 250 && rpm < 500) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "none" });
            bg.rpm_750.css({ display: "none" });
            bg.rpm_1000.css({ display: "none" });
            bg.rpm_1250.css({ display: "none" });
            bg.rpm_1500.css({ display: "none" });
            bg.rpm_1750.css({ display: "none" });
            bg.rpm_2000.css({ display: "none" });
            bg.rpm_2250.css({ display: "none" });
            bg.rpm_2500.css({ display: "none" });
            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 500 && rpm < 750) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "none" });
            bg.rpm_1000.css({ display: "none" });
            bg.rpm_1250.css({ display: "none" });
            bg.rpm_1500.css({ display: "none" });
            bg.rpm_1750.css({ display: "none" });
            bg.rpm_2000.css({ display: "none" });
            bg.rpm_2250.css({ display: "none" });
            bg.rpm_2500.css({ display: "none" });
            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });


          }
          if (rpm >= 750 && rpm < 1000) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "none" });
            bg.rpm_1250.css({ display: "none" });
            bg.rpm_1500.css({ display: "none" });
            bg.rpm_1750.css({ display: "none" });
            bg.rpm_2000.css({ display: "none" });
            bg.rpm_2250.css({ display: "none" });
            bg.rpm_2500.css({ display: "none" });
            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 1000 && rpm < 1250) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "none" });
            bg.rpm_1500.css({ display: "none" });
            bg.rpm_1750.css({ display: "none" });
            bg.rpm_2000.css({ display: "none" });
            bg.rpm_2250.css({ display: "none" });
            bg.rpm_2500.css({ display: "none" });
            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 1250 && rpm < 1500) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "none" });
            bg.rpm_1750.css({ display: "none" });
            bg.rpm_2000.css({ display: "none" });
            bg.rpm_2250.css({ display: "none" });
            bg.rpm_2500.css({ display: "none" });
            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 1500 && rpm < 1750) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "none" });
            bg.rpm_2000.css({ display: "none" });
            bg.rpm_2250.css({ display: "none" });
            bg.rpm_2500.css({ display: "none" });
            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 1750 && rpm < 2000) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "none" });
            bg.rpm_2250.css({ display: "none" });
            bg.rpm_2500.css({ display: "none" });
            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 2000 && rpm < 2250) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "none" });
            bg.rpm_2500.css({ display: "none" });
            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 2250 && rpm < 2500) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "none" });
            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 2500 && rpm < 2750) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "none" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 2750 && rpm < 3000) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "none" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 3000 && rpm < 3250) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "none" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 3250 && rpm < 3500) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "none" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 3500 && rpm < 3750) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "none" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 3750 && rpm < 4000) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "none" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 4000 && rpm < 4250) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "none" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 4250 && rpm < 4500) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "none" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 4500 && rpm < 4750) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "none" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 4750 && rpm < 5000) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "none" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "block" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }

          if (rpm >= 5000 && rpm < 5250) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "none" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "block" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 5250 && rpm < 5500) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "none" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "block" });
            tacho.shiftlight_5500.css({ display: "block" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }

          if (rpm >= 5500 && rpm < 5750) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "none" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "block" });
            tacho.shiftlight_5500.css({ display: "block" });
            tacho.shiftlight_6000.css({ display: "block" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 5750 && rpm < 6000) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "block" });
            bg.rpm_6000.css({ display: "none" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "block" });
            tacho.shiftlight_5500.css({ display: "block" });
            tacho.shiftlight_6000.css({ display: "block" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 6000 && rpm < 6250) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "block" });
            bg.rpm_6000.css({ display: "block" });

            bg.rpm_6250.css({ display: "none" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "block" });
            tacho.shiftlight_5500.css({ display: "block" });
            tacho.shiftlight_6000.css({ display: "block" });
            tacho.shiftlight_6500.css({ display: "block" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 6250 && rpm < 6500) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "block" });
            bg.rpm_6000.css({ display: "block" });

            bg.rpm_6250.css({ display: "block" });
            bg.rpm_6500.css({ display: "none" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "block" });
            tacho.shiftlight_5500.css({ display: "block" });
            tacho.shiftlight_6000.css({ display: "block" });
            tacho.shiftlight_6500.css({ display: "block" });
            tacho.shiftlight_7000.css({ display: "none" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 6500 && rpm < 6750) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "block" });
            bg.rpm_6000.css({ display: "block" });

            bg.rpm_6250.css({ display: "block" });
            bg.rpm_6500.css({ display: "block" });
            bg.rpm_6750.css({ display: "none" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });


            tacho.shiftlight_5000.css({ display: "block" });
            tacho.shiftlight_5500.css({ display: "block" });
            tacho.shiftlight_6000.css({ display: "block" });
            tacho.shiftlight_6500.css({ display: "block" });
            tacho.shiftlight_7000.css({ display: "block" });
            tacho.shiftlight_7500.css({ display: "none" });
          }
          if (rpm >= 6750 && rpm < 7000) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "block" });
            bg.rpm_6000.css({ display: "block" });

            bg.rpm_6250.css({ display: "block" });
            bg.rpm_6500.css({ display: "block" });
            bg.rpm_6750.css({ display: "block" });
            bg.rpm_7000.css({ display: "none" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "block" });
            tacho.shiftlight_5500.css({ display: "block" });
            tacho.shiftlight_6000.css({ display: "block" });
            tacho.shiftlight_6500.css({ display: "block" });
            tacho.shiftlight_7000.css({ display: "block" });
            tacho.shiftlight_7500.css({ display: "none" });
          }

          if (rpm >= 7000 && rpm < 7250) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "block" });
            bg.rpm_6000.css({ display: "block" });

            bg.rpm_6250.css({ display: "block" });
            bg.rpm_6500.css({ display: "block" });
            bg.rpm_6750.css({ display: "block" });
            bg.rpm_7000.css({ display: "block" });
            bg.rpm_7250.css({ display: "none" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            if (!tacho.shiftlight_7500.n.classList.contains("blink")) {
              tacho.shiftlight_7500.n.classList.add("blink");
            }
            tacho.shiftlight_7500.css({ display: "inline" });
          }

          if (rpm >= 7250 && rpm < 7500) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "block" });
            bg.rpm_6000.css({ display: "block" });

            bg.rpm_6250.css({ display: "block" });
            bg.rpm_6500.css({ display: "block" });
            bg.rpm_6750.css({ display: "block" });
            bg.rpm_7000.css({ display: "block" });
            bg.rpm_7250.css({ display: "block" });
            bg.rpm_7500.css({ display: "none" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            if (!tacho.shiftlight_7500.n.classList.contains("blink")) {
              tacho.shiftlight_7500.n.classList.add("blink");
            }
            tacho.shiftlight_7500.css({ display: "inline" });
          }
          if (rpm >= 7500 && rpm < 7750) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "block" });
            bg.rpm_6000.css({ display: "block" });

            bg.rpm_6250.css({ display: "block" });
            bg.rpm_6500.css({ display: "block" });
            bg.rpm_6750.css({ display: "block" });
            bg.rpm_7000.css({ display: "block" });
            bg.rpm_7250.css({ display: "block" });
            bg.rpm_7500.css({ display: "block" });
            bg.rpm_7750.css({ display: "none" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            if (!tacho.shiftlight_7500.n.classList.contains("blink")) {
              tacho.shiftlight_7500.n.classList.add("blink");
            }
            tacho.shiftlight_7500.css({ display: "inline" });
          }
          if (rpm >= 7750 && rpm < 8000) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "block" });
            bg.rpm_6000.css({ display: "block" });

            bg.rpm_6250.css({ display: "block" });
            bg.rpm_6500.css({ display: "block" });
            bg.rpm_6750.css({ display: "block" });
            bg.rpm_7000.css({ display: "block" });
            bg.rpm_7250.css({ display: "block" });
            bg.rpm_7500.css({ display: "block" });
            bg.rpm_7750.css({ display: "block" });
            bg.rpm_8000.css({ display: "none" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            if (!tacho.shiftlight_7500.n.classList.contains("blink")) {
              tacho.shiftlight_7500.n.classList.add("blink");
            }
            tacho.shiftlight_7500.css({ display: "inline" });
          }
          if (rpm >= 8000 && rpm < 8250) {
            bg.rpm_0.css({ display: "block" });
            bg.rpm_250.css({ display: "block" });
            bg.rpm_500.css({ display: "block" });
            bg.rpm_750.css({ display: "block" });
            bg.rpm_1000.css({ display: "block" });
            bg.rpm_1250.css({ display: "block" });
            bg.rpm_1500.css({ display: "block" });
            bg.rpm_1750.css({ display: "block" });
            bg.rpm_2000.css({ display: "block" });
            bg.rpm_2250.css({ display: "block" });
            bg.rpm_2500.css({ display: "block" });
            bg.rpm_2750.css({ display: "block" });
            bg.rpm_3000.css({ display: "block" });
            bg.rpm_3250.css({ display: "block" });
            bg.rpm_3500.css({ display: "block" });
            bg.rpm_3750.css({ display: "block" });
            bg.rpm_4000.css({ display: "block" });
            bg.rpm_4250.css({ display: "block" });
            bg.rpm_4500.css({ display: "block" });
            bg.rpm_4750.css({ display: "block" });
            bg.rpm_5000.css({ display: "block" });
            bg.rpm_5250.css({ display: "block" });
            bg.rpm_5500.css({ display: "block" });
            bg.rpm_5750.css({ display: "block" });
            bg.rpm_6000.css({ display: "block" });

            bg.rpm_6250.css({ display: "block" });
            bg.rpm_6500.css({ display: "block" });
            bg.rpm_6750.css({ display: "block" });
            bg.rpm_7000.css({ display: "block" });
            bg.rpm_7250.css({ display: "block" });
            bg.rpm_7500.css({ display: "block" });
            bg.rpm_7750.css({ display: "block" });
            bg.rpm_8000.css({ display: "block" });

            tacho.shiftlight_5000.css({ display: "none" });
            tacho.shiftlight_5500.css({ display: "none" });
            tacho.shiftlight_6000.css({ display: "none" });
            tacho.shiftlight_6500.css({ display: "none" });
            tacho.shiftlight_7000.css({ display: "none" });
            if (!tacho.shiftlight_7500.n.classList.contains("blink")) {
              tacho.shiftlight_7500.n.classList.add("blink");
            }
            tacho.shiftlight_7500.css({ display: "inline" });


          }

        }

      }
    }

    function limitVal(min, val, max) {
      return Math.min(Math.max(min, val), max);
    }

    function updateAccelerometer(data) {
      var roundedGX2 = (data.sensors.gx2 / 10).toFixed(2);
      var roundedGY2 = (-data.sensors.gy2 / 10).toFixed(2);

      if (rsTacho === true) {
        bg.gMeterPoint_rs.css({ transform: `translate(${limitVal(-10, data.sensors.gx2, 10) / 2}px, ${-limitVal(-10, data.sensors.gy2, 10) / 2}px` });
        bg.gMeterRight_rs.text(roundedGX2 > 0.00 ? roundedGX2 : "0.00")
        bg.gMeterLeft_rs.text(roundedGX2 < 0.00 ? -roundedGX2 : "0.00")
        bg.gMeterDown_rs.text(roundedGY2 > 0.00 ? roundedGY2 : "0.00")
        bg.gMeterUp_rs.text(roundedGY2 < 0.00 ? -roundedGY2 : "0.00")
      } else {
        bg.gMeterPoint.css({ transform: `translate(${limitVal(-10, data.sensors.gx2, 10) / 2}px, ${-limitVal(-10, data.sensors.gy2, 10) / 2}px` });
        bg.gMeterRight.text(roundedGX2 > 0.00 ? roundedGX2 : "0.00")
        bg.gMeterLeft.text(roundedGX2 < 0.00 ? -roundedGX2 : "0.00")
        bg.gMeterDown.text(roundedGY2 > 0.00 ? roundedGY2 : "0.00")
        bg.gMeterUp.text(roundedGY2 < 0.00 ? -roundedGY2 : "0.00")
      }
    }

    $window.redrawSpeedoTicks = (lim, bigSep, smallSep) => {
      var startAngle = 147 * Math.PI / 180;
      var maxAngle = 320;
      var centerX = 180, centerY = 37.4, radiusInt = 33.5, radiusExt = 35, radiusIntBig = 33.5;

      /*unitspeedratio = maxAngle*Math.PI/(lim*180)*unitspeedConv;
      var tickD = "";
      for(var ib = 0; ib<= (lim/bigSep) ; ib++){
        for(var is = 0; is<= (bigSep/smallSep); is++){
          var curAng = (ib*maxAngle/(lim/bigSep)+maxAngle*(1/(lim/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng > (maxAngle*Math.PI/180)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }
      var txtRadius = 15.5;
      speedoDisplay.speedTicks.attr({d: tickD});
      var fontSize = 3;
      if(lim/bigSep > 12){
        fontSize = fontSize * (10/ (lim/bigSep)) ;
      }
      //console.log("fontSize",fontSize,"r", (12/ lim/bigSep), "lim", lim, "bigSep", bigSep);
      var testStyle = {"font-size":fontSize+"px","font-style":"normal","font-weight":"bold","font-stretch":"normal","font-family":"Nasalization","fill":"#ffffff","fill-opacity":1,"stroke-width":0.04861574,"text-align":"center","text-anchor":"middle"};
      speedoDisplay.speedTicksText.empty();
      for(var ib = 0; ib<=(lim/bigSep) ; ib++){
        var curAng = (ib*maxAngle/(lim/bigSep)) *Math.PI/180;
        var sx = (centerX) + Math.cos(startAngle+curAng) * txtRadius;
        var sy = (centerY + 0.90) + Math.sin(startAngle+curAng) * txtRadius;
        var ts = hu('<tspan>', speedoDisplay.speedTicksText)
        .attr({x: sx,y: sy})
        .text((ib*bigSep))
        .css(testStyle);
      }*/
    }


    $window.redrawTachoTicks = (lim, bigSep, smallSep, red) => {
      var startAngle = 0;
      var maxAngle = 247;
      var centerX = 67.7, centerY = 57.5, radiusInt = 34, radiusExt = 36, radiusIntBig = 34;
      rpmRatio = maxAngle * Math.PI / (lim * 180);

      var tickD = "";
      /*for(var ib = 0; ib<= (lim/bigSep) ; ib++){
        for(var is = 0; is<= (bigSep/smallSep); is++){
          var curAng = (ib*maxAngle/(lim/bigSep)+maxAngle*(1/(lim/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng < (maxAngle*Math.PI/180)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }*/
      var txtRadius = 41;
      tacho.Ticks.attr({ d: tickD });
      var testStyle = { "font-style": "normal", "font-weight": "bold", "font-stretch": "normal", "font-family": "Nasalization", "fill-opacity": 1, "stroke-width": 0.04861574, "text-align": "center", "text-anchor": "middle" };
      tacho.TicksText.empty();
      /*for(var ib = 0; ib<=(lim/bigSep) ; ib++){
        var curAng = (ib*maxAngle/(lim/bigSep)) *Math.PI/180;
        var sx = (centerX) + Math.cos(startAngle+curAng) * txtRadius;
        var sy = (centerY + 0.90) + Math.sin(startAngle+curAng) * txtRadius;
        var ts = hu('<tspan>', tacho.TicksText)
        .attr({x: sx,y: sy})
        .text((ib*bigSep*0.001))
        .css(testStyle)
        .css({"fill":(ib*bigSep >= red)?"#ef3535":"#fff"});
      }*/
    }

    function updateGagueFuel(data) {
      if (speedoInitialised) {
        var speedAng = 226 + ((data["electrics"]["fuel"] * 0.05));
        var startAngle = 90 * Math.PI / 180;
        var maxRad = (-180 * Math.PI / 180) + startAngle;
        var speedRad = (-data["electrics"]["fuel"] * Math.PI + startAngle);
        var lowRad = -22.5 * Math.PI / 180;
        //speedRad = Math.max(speedRad, maxRad);
        //console.log("maxRad",maxRad,"start",startAngle,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad-startAngle)*180/Math.PI);
        //speedoDisplay.needle.css({transform: `rotate(${speedAng}deg)` });
        if (Math.abs(speedRad - cachedAng.fuel) < refreshAng * 4) { return; }
        cachedAng.fuel = speedRad;

        var centerX = 116.1, centerY = 22.5, radius = 12, largeArcFlag = ((speedRad - startAngle) > Math.PI) ? 1 : 0;
        //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);


        var sx1 = (centerX) + Math.cos(startAngle) * radius;
        var sy1 = (centerY) + Math.sin(startAngle) * radius;
        var ex1 = (centerX) + Math.cos(startAngle + lowRad) * radius;
        var ey1 = (centerY) + Math.sin(startAngle + lowRad) * radius;

        var sx2 = (centerX) + Math.cos(startAngle + lowRad) * radius;
        var sy2 = (centerY) + Math.sin(startAngle + lowRad) * radius;
        var ex2 = (centerX) + Math.cos(speedRad) * radius;
        var ey2 = (centerY) + Math.sin(speedRad) * radius;

        if (data["electrics"]["fuel"] > 0.125) {
          gagues.fuel.low.attr({
            d: "M " + sx1 + "," + sy1 +
              " A" + radius + "," + radius + " 0 " + largeArcFlag + ",0 " + ex1 + "," + ey1
          });
          gagues.fuel.normal.attr({
            d: "M " + sx2 + "," + sy2 +
              " A" + radius + "," + radius + " 0 " + largeArcFlag + ",0 " + ex2 + "," + ey2
          });
        } else {
          gagues.fuel.low.attr({
            d: "M " + sx1 + "," + sy1 +
              " A" + radius + "," + radius + " 0 " + largeArcFlag + ",0 " + ex2 + "," + ey2
          });
          gagues.fuel.normal.attr({
            d: "M " + sx2 + "," + sy2 +
              " A" + radius + "," + radius + " 0 " + largeArcFlag + ",0 " + sx2 + "," + sy2
          });
        }
      }
    }

    function updateGagueTemp(data) {
      if (speedoInitialised) {
        var startAngle = -90 * Math.PI / 180;
        var maxRad = -Math.PI * 0.5 + startAngle;
        var minRad = (-45 * Math.PI / 180) + startAngle;
        var redRad = (-135 * Math.PI / 180) + startAngle;
        var speedRad = (-(data["electrics"]["watertemp"] - 50) * Math.PI / (80));
        speedRad = Math.max(speedRad, maxRad);
        speedRad = Math.min(speedRad, 0);
        //console.log("maxRad",maxRad,"start",startAngle,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad)*180/Math.PI);
        //speedoDisplay.needle.css({transform: `rotate(${speedAng}deg)` });
        if (Math.abs(speedRad - cachedAng.temp) < refreshAng * 4) { return; }
        cachedAng.temp = speedRad;

        var centerX = 155.1, centerY = 22.5, radius = 12, largeArcFlag = ((speedRad - startAngle) > Math.PI) ? 1 : 0;
        //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);
        var sx = (centerX) + Math.cos(startAngle) * radius;
        var sy = (centerY) - Math.sin(startAngle) * radius;


        var mx = (centerX) + Math.cos(minRad) * radius;
        var my = (centerY) - Math.sin(minRad) * radius;
        var rx = (centerX) + Math.cos(redRad) * radius;
        var ry = (centerY) - Math.sin(redRad) * radius;

        var cx = (centerX) + Math.cos(speedRad + startAngle) * radius;
        var cy = (centerY) - Math.sin(speedRad + startAngle) * radius;

        if (data["electrics"]["watertemp"] < 70) { //only min
          gagues.temp.low.attr({
            d: "M " + sx + "," + sy +
              " A" + radius + "," + radius + " 0 " + largeArcFlag + ",1 " + cx + "," + cy
          });
          gagues.temp.normal.attr({ d: "M " + cx + "," + cy + " " + cx + "," + cy });
          gagues.temp.high.attr({ d: "M " + cx + "," + cy + " " + cx + "," + cy });
        } else {
          gagues.temp.low.attr({
            d: "M " + sx + "," + sy +
              " A" + radius + "," + radius + " 0 0,1 " + mx + "," + my
          });

          if (data["electrics"]["watertemp"] < 110) { //no RED
            gagues.temp.normal.attr({
              d: "M " + mx + "," + my +
                " A" + radius + "," + radius + " 0 " + largeArcFlag + ",1 " + cx + "," + cy
            });
            gagues.temp.high.attr({ d: "M " + cx + "," + cy + " " + cx + "," + cy });
          } else {
            gagues.temp.normal.attr({
              d: "M " + mx + "," + my +
                " A" + radius + "," + radius + " 0 " + largeArcFlag + ",1 " + rx + "," + ry
            });
            gagues.temp.high.attr({
              d: "M " + rx + "," + ry +
                " A" + radius + "," + radius + " 0 0,1 " + cx + "," + cy
            });
          }

        }
        //gagues.fuel.normal.attr({d: "M " + ex1 + "," + ey1 + " " +ex2+","+ey2});
      }
    }

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if (!ready) {
        console.log("calling setup while svg not fully loaded");
        setTimeout(function () { $window.setup(data) }, 100);
        return;
      }

      //console.log("setup",data);
      painduchocolat.root.n.style.display = "none";
      if (data.unit == "metric") {
        speedoDisplay.speedUnit.text("km/h");
        unitspeedConv = 3.6;
        redrawSpeedoTicks(data.max_kph, data.speedo_metric_sep_big, data.speedo_metric_sep_small);
      }
      else {
        speedoDisplay.speedUnit.text("mph");
        unitspeedConv = 2.23694;
        redrawSpeedoTicks(data.max_mph, data.speedo_imp_sep_big, data.speedo_imp_sep_small);
      }

      /*if(data.max_rpm > 5000)
        redrawTachoTicks(data.max_rpm,1000,1000,data.red_rpm);
      else*/
      redrawTachoTicks(data.max_rpm, 1000, 500, data.red_rpm);

    }



    $window.initMap = (data) => {
      navDimensions = data.viewParams = [
        data.terrainOffset[0],
        data.terrainOffset[1],
        data.terrainSize[0],
        data.terrainSize[1]
      ];

      $scope.$apply(() => {
        vm.mapData = data;
      });

      navContainer.style.width = data.terrainSize[0] + "px";
      navContainer.style.height = data.terrainSize[1] + "px";
    }

    $window.updateMap = (data) => {
      var focusX = -data.x;
      var focusY = data.y;
      var origin = `${((navDimensions[0] * -1)) - focusX}px ${((navDimensions[1] * -1)) - focusY}px`;
      navContainer.style.transformOrigin = origin;
      var translateX = ((((navDimensions[0])) + 512) + focusX);
      var translateY = ((((navDimensions[1])) + 256) + focusY);
      navContainer.style.transform = `translate3d(${translateX}px,${translateY}px, 0px) rotateX(${55}deg) rotateZ(${180 + (data.rotation + 360)}deg) scale(1)`;
    }

    var hue = 0;

    function setElec(val, state, key) {
      if (val === undefined || val === null) { console.error("setElec: svg element not found", key); return; }
      if (state === undefined || state === null) { console.error("setElec: state not found", key); val.n.style.display = "none"; return; }
      var cssState = (state === true || state > 0.1) ? "inline" : "none";
      val.n.style.display = cssState;
      //val.n.setAttribute("opacity", (state || state>0.1)?1.0:0.3)
    }

    $window.updateElectrics = (data) => {
      if (data.electrics.cruiseControlActive === undefined) { data.electrics.cruiseControlActive = false }
      for (var k in electrics.lights) {
        setElec(electrics.lights[k], data.electrics[k], k);
      }

      electrics.esc.n.style.display = (data.electrics["esc"] == 1) ? "inline" : "none";
      if (data.electrics["esc"] === undefined) {
        //nope
      } else {
        if (electrics.esc.n.classList.contains("blink") !== (data.electrics["esc"] === 1) && data.electrics["escActive"]) {
          electrics.esc.n.classList.toggle("blink", data.electrics["esc"] === 1);
        }
        if (electrics.esc.n.classList.contains("blink") && !data.electrics["escActive"]) {
          electrics.esc.n.classList.remove("blink");
        }
      }
      electrics.tcs.n.style.display = (data.electrics["tcs"] === 1) ? "inline" : "none";
      if (data.electrics["tcs"] === undefined) {
        //nope
      } else {
        if (electrics.tcs.n.classList.contains("blink") !== (data.electrics["tcs"] === 1) && data.electrics["tcsActive"]) {
          electrics.tcs.n.classList.toggle("blink", data.electrics["tcs"] === 1);
        }
        if (electrics.tcs.n.classList.contains("blink") && !data.electrics["tcsActive"]) {
          electrics.tcs.n.classList.remove("blink");
        }
      }

      electrics.temp_logo.css({
        "stroke": (data.electrics.watertemp > 110) ? "#ef3535" : "#fff",
        "fill": (data.electrics.watertemp > 110) ? "#ef3535" : "#fff"
      });
      electrics.fuel_logo.css({ "fill": (data.electrics.lowfuel) ? "#ef3535" : "#fff" });

      setElec(electrics.lights_fog_front, data.electrics["fog"], "fog");

      if (data.temp >= 0) {
        electrics.temp_env_txt.text("+" + (data.temp).toFixed(1).replace('.', ',') + "°C");
      } else {
        electrics.temp_env_txt.text("-" + (data.temp).toFixed(1).replace('.', ',') + "°C");
      }


      electrics.lights_battery.n.style.display = (data.electrics.engineRunning < 0.1) ? "inline" : "none";

    }

    //https://stackoverflow.com/a/56266358
    function isColor(strColor) {
      var s = new Option().style;
      s.color = strColor;
      return s.color !== "";
    }

    function getRPM(data) {
      if (rsTacho === false) {
        if (data["electrics"]["watertemp"] < 65) {
          bg.rpm_Tachometer_4000.css({ "display": "block" });
          bg.rpm_Tachometer_6000.css({ "display": "none" });
          bg.rpm_Tachometer_6500.css({ "display": "none" });
        } else if (data["electrics"]["watertemp"] < 85) {
          bg.rpm_Tachometer_4000.css({ "display": "none" });
          bg.rpm_Tachometer_6000.css({ "display": "block" });
          bg.rpm_Tachometer_6500.css({ "display": "none" });
        } else {
          bg.rpm_Tachometer_4000.css({ "display": "none" });
          bg.rpm_Tachometer_6000.css({ "display": "none" });
          bg.rpm_Tachometer_6500.css({ "display": "block" });
        }
      } else {
        if (data["electrics"]["watertemp"] < 65) {
          bg.rpm_Tachometer_4000_rs.css({ "display": "block" });
          bg.rpm_Tachometer_6000_rs.css({ "display": "none" });
          bg.rpm_Tachometer_6500_rs.css({ "display": "none" });
        } else if (data["electrics"]["watertemp"] < 85) {
          bg.rpm_Tachometer_4000_rs.css({ "display": "none" });
          bg.rpm_Tachometer_6000_rs.css({ "display": "block" });
          bg.rpm_Tachometer_6500_rs.css({ "display": "none" });
        } else {
          bg.rpm_Tachometer_4000_rs.css({ "display": "none" });
          bg.rpm_Tachometer_6000_rs.css({ "display": "none" });
          bg.rpm_Tachometer_6500_rs.css({ "display": "block" });
        }
      }
    }

    $window.updateMode = (data) => {
      if (!ready) {
        console.log("calling updateMode while svg not fully loaded");
        setTimeout(function () { $window.updateMode(data) }, 100);
        return;
      }
      //hex color without # works in html but not in svg BECAUSE
      var s = new Option().style;
      s.color = data.col;
      data.col = s.color;

      // RS1 = Driftmode, RS2 = Racemode
      var mode_Comfort = "rgb(52, 56, 56)", mode_Dynamic = "rgb(30, 124, 204)", mode_RS1 = "rgb(105, 50, 0)", mode_RS2 = "rgb(143, 1, 1)";


      if (data === null) {
        console.error("GSG");
      } else {
        console.log("debug message " + data.col);
        console.log("debug message " + rsTacho);

      }

      if (data.col === mode_Comfort) {
        rsTacho = false;
        drivemodes.mode_Comfort.css({ "display": "block" });
        drivemodes.mode_Dynamic.css({ "display": "none" });
        drivemodes.mode_rs1.css({ "display": "none" });
        drivemodes.mode_rs2.css({ "display": "none" });
      } else if (data.col === mode_Dynamic) {
        rsTacho = false;
        drivemodes.mode_Comfort.css({ "display": "none" });
        drivemodes.mode_Dynamic.css({ "display": "block" });
        drivemodes.mode_rs1.css({ "display": "none" });
        drivemodes.mode_rs2.css({ "display": "none" });
      } else if (data.col === mode_RS1) {
        rsTacho = true;
        drivemodes.mode_Comfort.css({ "display": "none" });
        drivemodes.mode_Dynamic.css({ "display": "none" });
        drivemodes.mode_rs1.css({ "display": "none" });
        drivemodes.mode_rs2.css({ "display": "block" });
      } else if (data.col === mode_RS2) {
        rsTacho = true;
        drivemodes.mode_Comfort.css({ "display": "none" });
        drivemodes.mode_Dynamic.css({ "display": "none" });
        drivemodes.mode_rs1.css({ "display": "block" });
        drivemodes.mode_rs2.css({ "display": "none" });
      } else {
        rsTacho = false;
        drivemodes.mode_Comfort.css({ "display": "none" });
        drivemodes.mode_Dynamic.css({ "display": "none" });
        drivemodes.mode_rs1.css({ "display": "none" });
        drivemodes.mode_rs2.css({ "display": "none" });
      }


    }

    $window.updateData = (data) => {
      if (data) {
        if (!ready) { console.log("not ready"); return; }
        // console.log(data);
        //hue = (hue+.5) % 360;
        //setTheme(hue);

        // Update PRNDS display
        updateGearIndicator(data);
        // Update Speed displays
        updateSpeedDisplays(data);
        updateTachoDisplays(data);
        updateAccelerometer(data);
        switchGauges(data);

        updateElectrics(data);

        getRPM(data);


        // if (data.gForcesVisible === true) {
        //   updateAccelerometer(data);
        //   consumGraph.root.css({opacity: 0});
        //   infoDisplay.infoValues.css({opacity: 0});
        //   consumGraph.graph_canvas.style.display = "none";
        // }
        // else {
        //   infoDisplay.accelerometer.css({opacity: 0});
        //   consumGraph.root.css({opacity: 1});
        //   consumGraph.graph_canvas.style.display = "inline";
        //   infoDisplay.infoValues.css({opacity: 1});
        // }
      }
    }
    //ready = true;
    //$window.updateConsum({current:0, average:0, range:0});
  });