//console.log("load gaugesScreen");
angular.module('gaugesScreen', [])



  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];

//new from ccf2
    var text = {  };
    var driveMode = {  };

    var speedoDisplay = { gears: {}};

    var tacho = {  };
    var navDisplay = {};
    var infoDisplay = {};
    var consumGraph = {values:{current: 0,avg: 0}};
    var electrics = {lights:{} };
    var gauges = {fuel:{},temp:{}};

    var backgroundGradient = {};
    var overlayGradient = {};
    var unit = "metric";
    var navMarkerGradient = {};
    var pribl = {};
    var templ = {};
    var roots = {};

    // var backgroundClipGradient;

    var speedoInitialised = true;
    var currentGear = '';
    var cachedAng = {speedo:-100, tacho:-100, temp:-100, fuel:-100};
    var refreshAng = 0.25*Math.PI/180;

    var ready = false;

    var units = {uiUnitConsumptionRate: "metric",
    uiUnitDate: "ger",
    uiUnitEnergy: "metric",
    uiUnitLength: "metric",
    uiUnitPower: "hp",
    uiUnitPressure: "bar",
    uiUnitTemperature: "c",
    uiUnitTorque: "metric",
    uiUnitVolume: "l",
    uiUnitWeight: "kg"};
    var unitspeedConv = 3.6;
    var unitspeedratio = 2.0*Math.PI*1.5/260;
    var rpmRatio = 0.1;

  $scope.data = {}

    var painduchocolat = {}; //une tradi bien cuite s'il vous plait
    var anim = {};
    var animi = {};
    var tht = {};


    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
      svg = $element[0].children[0].children[0];
      roots.templ = hu('#templ', svg);
      roots.gasl = hu('#gasl', svg);
      roots.rpm2 = hu('#rpm2', svg);
      roots.nimb = hu('#nimb', svg);

      roots.stat = hu('#stat', svg);
      roots.pereg = hu('#pereg', svg);
      roots.sport = hu('#sport', svg);
      roots.comfort = hu('#comfort', svg);
      roots.spd2 = hu('#spd2', svg);


      painduchocolat.root = hu('#layer_wip', svg);
      painduchocolat.txt = hu('#wip.txt', painduchocolat.root);
    
      // speedometer
      speedoDisplay.root = hu('#speedometer', svg);
      speedoDisplay.speedometerText = hu('#speedometerText', speedoDisplay.root)
    
      speedoDisplay.speedUnit = hu('#speedUnit', speedoDisplay.speedometerText);
      speedoDisplay.speedTicks = hu('#speedTicks', speedoDisplay.speedometerText);
      speedoDisplay.speedTicks.css({'stroke': `rgba(255, 255, 255, 0.5)`, 'stroke-width': '0.5px'});
      speedoDisplay.speedTicksText  = hu('#speedTicksText', speedoDisplay.speedometerText);
      speedoDisplay.gears.P = hu('#gearPP', speedoDisplay.speedometerText);
      speedoDisplay.gears.R = hu('#gearRR', speedoDisplay.speedometerText);
      speedoDisplay.gears.N = hu('#gearNN', speedoDisplay.speedometerText);
      speedoDisplay.gears.D = hu('#gearDD', speedoDisplay.speedometerText);
      speedoDisplay.gears.S = hu('#gearSS', speedoDisplay.speedometerText);
  

      //speedoDisplay.gears.S = hu('#gearS', speedoDisplay.gears_root);
      speedoDisplay.needle = hu('#needle', speedoDisplay.root);
      //speedoDisplay.needle.css({transformOrigin: '68px 33px', transform: 'rotate(227deg)'}).attr({class: "fade-in"});
      //speedoDisplay.needle.attr({class: "fade-in"});
      speedoDisplay.needle_bar = hu('#needle_bar', speedoDisplay.root);
      //speedoDisplay.needle_bar.attr({class: "fade-in"});
      speedoDisplay.needle_gradients = [];
      speedoDisplay.needle_gradients.push(hu('#radialGradient965', svg));
      speedoDisplay.needle_lingradient = hu('#linearGradient1357', svg);
      speedoDisplay.needle_bar_highlight = hu('#needle_bar_highlight', speedoDisplay.root);
      speedoDisplay.needle_bar_highlightGrad = hu('#linearGradient1390', svg);

      tacho.root = hu('#tacho', svg);
      tacho.bar = hu('#rpm_needle_bar', tacho.root);
//      tacho.needle = hu('#rpm_needle', tacho.root);
      tacho.needle = hu('#needle', tacho.root);
//	  tacho.needle = hu('#RPMNeedle', svg);  //new needle
      tacho.Ticks = hu('#rpmTicks', tacho.root);
      tacho.Ticks.css({'stroke': `rgba(255, 255, 255, 0.5)`, 'stroke-width': '0.5px'});
      tacho.TicksText  = hu('#rpmTicksText', tacho.root);
      tacho.needle_gradients = [];
      tacho.needle_gradients.push(hu('#radialGradient965-1', svg));
      tacho.needle_lingradient = hu('#linearGradient1369', svg);
      tacho.rpm_needle_bar_highlight  = hu('#rpm_needle_bar_highlight', tacho.root);
      tacho.rpm_needle_bar_highlightGrad = hu('#linearGradient1392', svg);

      anim.spd = hu('#spd', anim.root);
	  
      animi.spdi = hu('#spdi', animi.root);


      pribl.hour = hu('#hour', pribl.root);
      pribl.min = hu('#min', pribl.root);
      pribl.cel = hu('#cel', pribl.root);
      pribl.pmam = hu('#pmam', pribl.root);
      pribl.odom = hu('#odom', pribl.root);



      // nav
      // navDisplay.root = hu('#navigation', svg);
      // navDisplay.overlay = hu('#MapOverlay', navDisplay.root);


      //speedoDisplay.speedometerText.attr({class: "grow"})
      // infoDisplay.root.attr({class: "slide-right"});
      // navDisplay.root.attr({class: "slide-left"});
      // var background = hu('#background', svg);
      // background.attr({class: 'map-fade'})

      electrics.root = hu('#lights_layer', svg);
      electrics.lights.signal_L = hu("#light_signal_L", electrics.root);
      electrics.lights.signal_R = hu("#light_signal_R", electrics.root);
      electrics.lights.lights = hu("#light_lights", electrics.root);
      electrics.lights.highbeam = hu("#light_highbeam", electrics.root);
      electrics.lights.fog = hu("#light_fog", electrics.root);
      electrics.lights.lowpressure = hu("#light_lowpressure", electrics.root);
      electrics.lights.parkingbrake = hu("#light_parkingbrake", electrics.root);
      electrics.lights.checkengine = hu("#light_checkengine", electrics.root);
      electrics.lights.hazard = hu("#light_hazard", electrics.root);
      electrics.lights.oil = hu("#light_oil", electrics.root);
      electrics.lights.cruiseControlActive = hu("#light_cruise", electrics.root);

      electrics.lights_battery = hu("#lights_battery", electrics.root);
      electrics.lights_fog_front = hu("#light_fog_front", electrics.root);
      electrics.esc = hu("#light_escActive", electrics.root);
      electrics.tcs = hu("#light_tcsActive", electrics.root);
      electrics.temp_logo = hu("#temp_logo", electrics.root);
      electrics.fuel_logo = hu("#fuel_logo", electrics.root);

      electrics.temp_env_txt = hu("#temp_txt", electrics.root);
      electrics.mode_txt = hu("#mode_txt", electrics.root);
      electrics.odo_txt = hu("#odo_txt", electrics.root);
      electrics.trip_txt = hu("#trip_txt", electrics.root);

// new from ccf2
      text.speedLimitDoubleDigit = hu('#speed_limit_doubledigit', gauges.root)
      text.speedLimitTripleDigit = hu('#speed_limit_tripledigit', gauges.root)
	  
      driveMode.drivemode_text = hu('#drivemode_text', gauges.root)
// end of new from ccf2

      ready = true;
    

    }
      function hardangle(data) {
        let rrr = Math.round(data["electrics"]["rpmTacho"]/10 )*10
        let children = roots.rpm2.n.childNodes
        for (let i = 0; i < children.length; i++) {
          let index = parseInt(children[i].id.replace("rpm_",""));
          children[i].style.display = (rrr > index*147.72)?"inline":"none"; 
      }


    }
    function widewize(data) {
      let fuel = data.electrics.fuel;
      let children = roots.gasl.n.childNodes
      for (let i = 0; i < children.length; i++) {
        let index = parseInt(children[i].id.replace("gas_","")); 
        children[i].style.display = (fuel >= index*0.052 )?"inline":"none";
      }
    
    }
    function sidewize(data) {
          let eeeee = data.electrics.watertemp -40
          let children = roots.templ.n.childNodes
          for (let i = 0; i < children.length; i++) {
            let index = parseInt(children[i].id.replace("tempeeeee_",""));
            children[i].style.display = (eeeee >= index*8.88)?"inline":"none";

        let val = data.electrics.odometer
        val *= (unit=="metric")?0.001:0.0006215;
        val = Math.min(val,999999)
        pribl.odom.text( val.toFixed(0) + (unit==="metric"?"km":"mi") );
//        let val2 = data.electrics.trip
//		val2 *= (units.uiUnitLength=="metric")?0.001:0.0006215;
//        val2 %=1000
//        pribl.trip_txt.text( val2.toFixed(1)+((units.uiUnitLength=="metric")?"km":"mi") )
        }
      
    
  }
//    function updateTachoDisplays(data) {
//      if (ready) {
//        //106deg
//        let angle = limitVal(-5000, data["electrics"]["rpmTacho"]-5000 , 5000) * 0.0212
//        tacho.needle.n.style["transform"] = 'rotate('+angle+'deg)'
//      }
//    }
    function updateTachoDisplays(data) {
      if (speedoInitialised) {   //speedoInitialised
//	    let angle = limitVal(-5000, data["electrics"]["rpmTacho"]-5000 , 5000) * 0.0212 //new
//        tacho.needle.n.style["transform"] = 'rotate('+angle+'deg)'						//stuff
        var speedAng = 270 + ((data["electrics"]["rpmTacho"] * 2.35));
        var startAngle = 90 * Math.PI / 180, speedRad = (data["electrics"]["rpmTacho"] * rpmRatio) + startAngle;
        var maxRad = (260 * Math.PI / 180) + startAngle;
		let speed_i = data.electrics.wheelspeed		
        anim.spd.text((data.electrics.wheelspeed * (unit=="metric"?3.6:2.23694) ).toFixed(0));

//        animi.spdi.text((speed_i * (unit=="imperial"?3.6:2.23694) ).toFixed(0));
//        roots.spd2.text((data.electrics.wheelspeed * (unit=="metric"?3.6:2.23694) ).toFixed(0));
        const current_time = new Date(Date.now());
        var pid = fixClock(current_time.getMinutes());
        pribl.hour.text(fixClock(current_time.getHours(), " ") % 12 + ":" + pid) ;
        let envTemp = (data.customModules.environmentData.temperatureEnv)
        pribl.cel.text( envTemp.toFixed(0));
		

		
        speedRad = Math.min(speedRad, maxRad);
        if (Math.abs(speedRad - cachedAng.tacho) < refreshAng) { return; }
        cachedAng.tacho = speedRad;

        var centerX=105.0, centerY=50.0, radiusInt=45, radiusExt=40, largeArcFlag= ((speedRad-startAngle)>Math.PI)? 1 : 0, radiusExtH = -1 ;
        //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);
/*        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(speedRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(speedRad) * radiusExt;

        var ex1 = (centerX)  + Math.cos(speedRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(speedRad) * radiusInt*/ ;

//        var mx1 = (centerX) + Math.cos(speedRad) * 20;
//        var my1 = (centerY) + Math.sin(speedRad) * 20;

//        tacho.bar.attr({d: "M " + sx1 + "," + sy1 +
//        " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
//        " L " + ex1 + "," + ey1  
//		+
//          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",1 " + sx2 + "," + sy2
//        });
		
//		let angle = limitVal(-5000, data["electrics"]["rpmTacho"]-5000 , 5000) * 0.0212
//        tacho.needle.n.style["transform"] = 'rotate('+angle+'deg)'
		
//        tacho.needle.attr({d: "M " + ex1 + "," + ey1 + " " +ex2+","+ey2});
//        tacho.needle_lingradient.attr({x1: ex1, y1: ey1, x2: ex2, y2: ey2});

//        ex2 = (centerX) + Math.cos(speedRad) * radiusExtH;
//        ey2 = (centerY) + Math.sin(speedRad) * radiusExtH;

//        ex1 = (centerX) + Math.cos(startAngle) * radiusExtH;
//        ey1 = (centerY) + Math.sin(startAngle) * radiusExtH;
//        tacho.rpm_needle_bar_highlight.attr({d: "M " + ex1 + "," + ey1 +
//        " A" + radiusExtH  + "," + radiusExtH  + " 0 "+largeArcFlag+",0 " + ex2 + "," + ey2});
//       tacho.rpm_needle_bar_highlightGrad.attr({x1: ex1, y1: ey1, x2: ex2, y2: ey2});

//        for(var E in tacho.needle_gradients){
//          tacho.needle_gradients[E].n.gradientTransform.baseVal[0].matrix.e = ex2;
//          tacho.needle_gradients[E].n.gradientTransform.baseVal[0].matrix.f = ey2;
//        }
//	    let angle = limitVal(-5000, data["electrics"]["rpmTacho"]-5000 , 5000) * 0.0212 //new
//        tacho.needle.n.style["transform"] = 'rotate('+angle+'deg)'						//stuff
      } 

    }
    function pmam(data) {
    const current_time = new Date(Date.now());
     if((fixClock(current_time.getHours()))>12)
    {
      pribl.pmam.text("PM");
    }
    else{
      pribl.pmam.text("AM");
    } 

    }
    function fixClock(v, fill="0"){
      return (v<10)? fill+v : v;
      
    }

    $window.redrawSpeedoTicks = (lim,bigSep,smallSep) => {
      var startAngle= 0;
      var maxAngle = 0;
      var centerX=111111111111111111111111103.5, centerY=57.5, radiusInt=33.5, radiusExt=35, radiusIntBig=33.5;

      unitspeedratio = maxAngle*Math.PI/(lim*180)*unitspeedConv;
      var tickD = "";
      for(var ib = 0; ib<= (lim/bigSep) ; ib++){
        for(var is = 0; is<= (bigSep/smallSep); is++){
          var curAng = (ib*maxAngle/(lim/bigSep)+maxAngle*(1/(lim/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng > (maxAngle*Math.PI/180)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }
      var txtRadius = 41;
      speedoDisplay.speedTicks.attr({d: tickD});
      var fontSize = 5;
      if(lim/bigSep > 12){
        fontSize = fontSize * (10/ (lim/bigSep)) ;
      }
      //console.log("fontSize",fontSize,"r", (12/ lim/bigSep), "lim", lim, "bigSep", bigSep);
      var testStyle = {"font-size":fontSize+"px","font-style":"normal","font-weight":"bold","font-stretch":"normal","font-family":"Nasalization","fill":"#ffffff","fill-opacity":1,"stroke-width":0.04861574,"text-align":"center","text-anchor":"middle"};
      speedoDisplay.speedTicksText.empty();
      for(var ib = 0; ib<=(lim/bigSep) ; ib++){
        var curAng = (ib*maxAngle/(lim/bigSep)) *Math.PI/180;
        var sx = (centerX) + Math.cos(startAngle+curAng) * txtRadius;
        var sy = (centerY + 0.90) + Math.sin(startAngle+curAng) * txtRadius;
        var ts = hu('<tspan>', speedoDisplay.speedTicksText)
        .attr({x: sx,y: sy})
        .text((ib*bigSep))
        .css(testStyle);
      }
    }


    $window.redrawTachoTicks = (lim,bigSep,smallSep,red) => {
      var startAngle = -50;
      var maxAngle = 240;
      var centerX = 2515125.7, centerY = 57.5, radiusInt = 34, radiusExt = 36, radiusIntBig = 34;
      rpmRatio = 230 * Math.PI / (lim * 170);

      var tickD = "";
      for(var ib = 0; ib<= (lim/bigSep) ; ib++){
        for(var is = 0; is<= (bigSep/smallSep); is++){
          var curAng = (ib*maxAngle/(lim/bigSep)+maxAngle*(1/(lim/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng < (maxAngle*Math.PI/180)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }
      var txtRadius = 41;
      tacho.Ticks.attr({d: tickD});
      var testStyle = {"font-style":"normal","font-weight":"bold","font-stretch":"normal","font-family":"Nasalization","fill-opacity":1,"stroke-width":0.04861574,"text-align":"center","text-anchor":"middle"};
      tacho.TicksText.empty();
      for(var ib = 0; ib<=(lim/bigSep) ; ib++){
        var curAng = (ib*maxAngle/(lim/bigSep)) *Math.PI/180;
        var sx = (centerX) + Math.cos(startAngle+curAng) * txtRadius;
        var sy = (centerY + 0.90) + Math.sin(startAngle+curAng) * txtRadius;
        var ts = hu('<tspan>', tacho.TicksText)
        .attr({x: sx,y: sy})
        .text((ib*bigSep*0.001))
        .css(testStyle)
        .css({"fill":(ib*bigSep >= red)?"#ef3535":"#fff"});
      }
    }

    function updateGaugeFuel(data) {
      if (speedoInitialised) {
        var speedAng = 226 + ((data["electrics"]["fuel"] * 0.05));
        var startAngle=90*Math.PI/180;
        var maxRad = (-180*Math.PI/180) + startAngle;
        var speedRad = (-data["electrics"]["fuel"]*Math.PI + startAngle );
        var lowRad = -22.5*Math.PI/180;
        //speedRad = Math.max(speedRad, maxRad);
        //console.log("maxRad",maxRad,"start",startAngle,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad-startAngle)*180/Math.PI);
        //speedoDisplay.needle.css({transform: `rotate(${speedAng}deg)` });
        if(Math.abs(speedRad-cachedAng.fuel)<refreshAng*4){return;}
        cachedAng.fuel = speedRad;

        var centerX=116.1, centerY=22.5, radius=12,largeArcFlag= ((speedRad-startAngle)>Math.PI)? 1 : 0;
        //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);


        var sx1 = (centerX) + Math.cos(startAngle) * radius;
        var sy1 = (centerY) + Math.sin(startAngle) * radius;
        var ex1 = (centerX) + Math.cos(startAngle+lowRad) * radius;
        var ey1 = (centerY) + Math.sin(startAngle+lowRad) * radius;

        var sx2 = (centerX) + Math.cos(startAngle+lowRad) * radius;
        var sy2 = (centerY) + Math.sin(startAngle+lowRad) * radius;
        var ex2 = (centerX) + Math.cos(speedRad) * radius;
        var ey2 = (centerY) + Math.sin(speedRad) * radius;

        if(data["electrics"]["fuel"] > 0.125){
          gauges.fuel.low.attr({d: "M " + sx1 + "," + sy1 +
            " A" + radius  + "," + radius  + " 0 "+largeArcFlag+",0 " + ex1 + "," + ey1
          });
          gauges.fuel.normal.attr({d: "M " + sx2 + "," + sy2 +
            " A" + radius  + "," + radius  + " 0 "+largeArcFlag+",0 " + ex2 + "," + ey2
          });
        }else{
          gauges.fuel.low.attr({d: "M " + sx1 + "," + sy1 +
            " A" + radius  + "," + radius  + " 0 "+largeArcFlag+",0 " + ex2 + "," + ey2
          });
          gauges.fuel.normal.attr({d: "M " + sx2 + "," + sy2 +
            " A" + radius  + "," + radius  + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2
          });
        }
      }

   

    }
    function updateGearIndicator(data) {
      // only update when gear is changed
      if (currentGear !== data.electrics.gear) {
        currentGear = data.electrics.gear;
        var xct = -1;
        if(isNaN(data.electrics.gear)){//auto,DCT
          speedoDisplay.gears["P"].n.style.display = "inline"; //because why not at this point
          if(data.electrics.gear.length >1){
            xct-= (data.electrics.gear[0]=="M")?5:2;
          }
          for (var key in speedoDisplay.gears) {
            if (key === data.electrics.gear) {
              speedoDisplay.gears[key].css({ fill: '#FFFFFF'});
              xct += 4;
            }
            else {
              speedoDisplay.gears[key].css({ fill: '#FFFFFF00'});
            }
          }
          if(xct <= 0){
            speedoDisplay.gears["D"].css({ fill: '#FE1111'}).text(data.electrics.gear[1]); //text(currentGear);
          }
          else{
            speedoDisplay.gears["D"].text("D");
          }
        }else{//manuel
          speedoDisplay.gears["P"].n.style.display = "none";
          switch(data.electrics.gear){
            case -1:
//              speedoDisplay.gears["R"].css({ fill: 'transparent'});
//              speedoDisplay.gears["N"].css({ fill: 'transparent'});
              speedoDisplay.gears["D"].css({ fill: '#FFFFFF'}).text("R");
              break;
            case 0:
              speedoDisplay.gears["R"].css({ fill: 'transparent'});
              speedoDisplay.gears["N"].css({ fill: 'transparent'});
              speedoDisplay.gears["D"].css({ fill: '#FFFFFF'}).text("N");//.text("1");
              break;
//            case 0:
//              speedoDisplay.gears["R"].css({ fill: 'transparent'});
//              speedoDisplay.gears["N"].css({ fill: '#FFFFFF'});
//              speedoDisplay.gears["D"].css({ fill: 'transparent'});//.text("1");
//              break;
            default:
              speedoDisplay.gears["R"].css({ fill: 'transparent'});
              speedoDisplay.gears["N"].css({ fill: 'transparent'});
              speedoDisplay.gears["D"].css({ fill: '#FE1111'}).text(data.electrics.gear);
              break;
          }
        }
      }

    }
    function updateGaugeTemp(data) {
      if (speedoInitialised) {
        var startAngle=-90*Math.PI/180;
        var maxRad = -Math.PI*0.5+startAngle;
        var minRad = (-45*Math.PI/180) + startAngle;
        var redRad = (-135*Math.PI/180) + startAngle;
        var speedRad = (-(data["electrics"]["watertemp"]-50)* Math.PI /(80));
        speedRad = Math.max(speedRad, maxRad);
        speedRad = Math.min(speedRad, 0);
        //console.log("maxRad",maxRad,"start",startAngle,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad)*180/Math.PI);
        //speedoDisplay.needle.css({transform: `rotate(${speedAng}deg)` });
        if(Math.abs(speedRad-cachedAng.temp)<refreshAng*4){return;}
        cachedAng.temp = speedRad;

        var centerX=155.1, centerY=22.5, radius=12,largeArcFlag= ((speedRad-startAngle)>Math.PI)? 1 : 0;
        //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);
        var sx = (centerX) + Math.cos(startAngle) * radius;
        var sy = (centerY) - Math.sin(startAngle) * radius;


        var mx = (centerX) + Math.cos(minRad) * radius;
        var my = (centerY) - Math.sin(minRad) * radius;
        var rx = (centerX) + Math.cos(redRad) * radius;
        var ry = (centerY) - Math.sin(redRad) * radius;

        var cx = (centerX) + Math.cos(speedRad+startAngle) * radius;
        var cy = (centerY) - Math.sin(speedRad+startAngle) * radius;

        if(data["electrics"]["watertemp"] < 70 ){ //only min
          gauges.temp.low.attr({d: "M " + sx + "," + sy +
            " A" + radius  + "," + radius  + " 0 "+largeArcFlag+",1 " + cx + "," + cy
          });
          gauges.temp.normal.attr({d: "M " + cx + "," + cy + " " +cx+","+cy});
          gauges.temp.high.attr({d: "M " + cx + "," + cy + " " +cx+","+cy});
        }else{
          gauges.temp.low.attr({d: "M " + sx + "," + sy +
            " A" + radius  + "," + radius  + " 0 0,1 " + mx + "," + my
          });

          if(data["electrics"]["watertemp"] < 110 ){ //no RED
            gauges.temp.normal.attr({d: "M " + mx + "," + my +
              " A" + radius  + "," + radius  + " 0 "+largeArcFlag+",1 " + cx + "," + cy
            });
            gauges.temp.high.attr({d: "M " + cx + "," + cy + " " +cx+","+cy});
          }else{
            gauges.temp.normal.attr({d: "M " + mx + "," + my +
              " A" + radius  + "," + radius  + " 0 "+largeArcFlag+",1 " + rx + "," + ry
            });
            gauges.temp.high.attr({d: "M " + rx + "," + ry +
              " A" + radius  + "," + radius  + " 0 0,1 " + cx + "," + cy
            });
          }

        }
        //gauges.fuel.normal.attr({d: "M " + ex1 + "," + ey1 + " " +ex2+","+ey2});
      }
    }

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }

      //console.log("setup",data);
      painduchocolat.root.n.style.display = "none";
      if(data.uiUnitLength == "metric"){
        speedoDisplay.speedUnit.text("km/h");
        unitspeedConv = 3.6;
        redrawSpeedoTicks(data.maxKPH,data.speedoMetricSepBig,data.speedoMetricSepSmall);
      }
      else{
        speedoDisplay.speedUnit.text("mph");
        unitspeedConv = 2.23694;
        redrawSpeedoTicks(data.maxMPH,data.speedoImperialSepBig,data.speedoImperialSepSmall);
      }

      for(let dk in data){
        if(typeof dk == "string" && dk.startsWith("uiUnit")){
          units[dk] = data[dk];
        }
      }
      
      vueEventBus.emit('SettingsChanged', {values:units})

      /*if(data.max_rpm > 5000)
        redrawTachoTicks(data.maxRPM,1000,1000,data.redRPM);
      else*/
        redrawTachoTicks(data.maxRPM,1000,500,data.redRPM);

    }



    $window.initMap = (data) => {
      navDimensions = data.viewParams = [
        data.terrainOffset[0],
        data.terrainOffset[1],
        data.terrainSize[0],
        data.terrainSize[1]
      ];

      $scope.$apply(() => {
        vm.mapData = data;
      });

      navContainer.style.width = data.terrainSize[0] + "px";
      navContainer.style.height = data.terrainSize[1] + "px";
    }

    $window.updateMap = (data) => {
      var focusX = -data.x;
      var focusY = data.y;
      var origin = `${((navDimensions[0] * -1)) - focusX}px ${((navDimensions[1] * -1)) - focusY}px`;
      navContainer.style.transformOrigin = origin;
      var translateX = ((((navDimensions[0])) + 512) + focusX);
      var translateY = ((((navDimensions[1])) + 256) + focusY);
      navContainer.style.transform = `translate3d(${translateX}px,${translateY}px, 0px) rotateX(${55}deg) rotateZ(${180 + (data.rotation + 360)}deg) scale(1)`;
    }

    var hue = 0;

    function setElec(val, state, key){
      if( val === undefined || val === null){console.error("setElec: svg element not found", key); return;}
      if( state === undefined || state === null){console.error("setElec: state not found", key);val.n.style.display = "none"; return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
      val.n.style.display = cssState;
      //val.n.setAttribute("opacity", (state || state>0.1)?1.0:0.3)
    }

    $window.updateElectrics = (data) => {
      let speed = (data.electrics.wheelspeed*unitspeedConv).toFixed(0)
      if(data.electrics.cruiseControlActive === undefined){data.electrics.cruiseControlActive = false}
      for(var k in electrics.lights){
        setElec(electrics.lights[k], data.electrics[k], k);
      }

      electrics.esc.n.style.display = (data.electrics["esc"]==1) ?"inline":"none";
      if(data.electrics["esc"] === undefined){
        //nope
      }else{
        if( electrics.esc.n.classList.contains("blink") !== (data.electrics["esc"]===1) && data.electrics["escActive"]){
          electrics.esc.n.classList.toggle("blink", data.electrics["esc"]===1);
        }
        if(electrics.esc.n.classList.contains("blink") && !data.electrics["escActive"]){
          electrics.esc.n.classList.remove("blink");
        }
      }
      electrics.tcs.n.style.display = (data.electrics["tcs"]===1) ?"inline":"none";
      if(data.electrics["tcs"] === undefined){
        //nope
      }else{
        if( electrics.tcs.n.classList.contains("blink") !== (data.electrics["tcs"]===1) && data.electrics["tcsActive"]){
          electrics.tcs.n.classList.toggle("blink", data.electrics["tcs"]===1);
        }
        if(electrics.tcs.n.classList.contains("blink") && !data.electrics["tcsActive"]){
          electrics.tcs.n.classList.remove("blink");
        }
      }

      electrics.temp_logo.css({
        "stroke":(data.electrics.watertemp > 110)?"#ef3535":"#fff",
        "fill":(data.electrics.watertemp > 110)?"#ef3535":"#fff"});
      electrics.fuel_logo.css({"fill":(data.electrics.lowfuel )?"#ef3535":"#fff"});

      setElec(electrics.lights_fog_front, data.electrics["fog"], "fog");

      let envTemp = UiUnits.temperature(data.customModules.environmentData.temperatureEnv)
      electrics.temp_env_txt.text( envTemp.val.toFixed(0) + envTemp.unit);

      electrics.lights_battery.n.style.display = (data.electrics.engineRunning<0.1)?"inline":"none";

      let conversion = unitspeedConv === 3.6?1:0.6213712
//      if(data.electrics.odometer){
//        let val = data.electrics.odometer
//        val *= (units.uiUnitLength=="metric")?0.001:0.0006215;
//        val = Math.min(999999,val);
//        electrics.odo_txt.text( val.toFixed(0)+((units.uiUnitLength=="metric")?"km":"mi") )
 //       val = data.electrics.trip
//        val *= (units.uiUnitLength=="metric")?0.001:0.0006215;
//        val %=1000
//        electrics.trip_txt.text( val.toFixed(1)+((units.uiUnitLength=="metric")?"km":"mi") )
//      }
    }

     //https://stackoverflow.com/a/56266358
     function isColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color !== "";
    }
	
// new from ccf2
    $window.speedLimitChanged = (speedlimit) => {
      if(!ready){
        setTimeout(function(){ $window.speedLimitChanged(speedlimit) }, 100);
        return;
      }
      let actualSpeedLimit = Math.round((speedlimit*unitspeedConv).toFixed(0)/10)*10
      if (actualSpeedLimit < 100) {
        text.speedLimitTripleDigit.text("")
        text.speedLimitDoubleDigit.text(actualSpeedLimit)
      } else {
        text.speedLimitDoubleDigit.text("")
        text.speedLimitTripleDigit.text(actualSpeedLimit)
      }
    }
// end of new from ccf2

    $window.updateMode = (data) => {
      if(!ready){
        console.log("calling updateMode while svg not fully loaded");
        setTimeout(function(){ $window.updateMode(data) }, 100);
        return;
      }
      //error checking because we can't trust people we work with
      if(data === null
      || data === undefined
      || data.modeName === null
      || data.modeName === undefined
      || typeof data.modeName !== "string"
      || data.modeColor === null
      || data.modeColor === undefined
      || typeof data.modeColor !== "string"){
        console.error("updateMode receive wrong arguments :", data);
        document.getElementById("layer_wip").style.display = "inline";
        document.getElementById("tspan995").innerHTML = "MODE";
//        driveMode.drivemode_text.text("inval. data");
        return;
      }
      if(!isColor(data.modeColor)){
        console.error("This mode color is not in html format :",data.modeColor)
        document.getElementById("layer_wip").style.display = "inline";
        document.getElementById("tspan995").innerHTML = "COL";
//        driveMode.drivemode_text.text("inval. colour");
        return;
      }

      //if you fixed without reload
      if(document.getElementById("tspan995").innerHTML === "COL"
      ||document.getElementById("tspan995").innerHTML === "MODE"){
        document.getElementById("layer_wip").style.display = "none";
      }

      //hex color without # works in html but not in svg BECAUSE
      var s = new Option().style;
      s.color = data.modeColor;
      data.modeColor = s.color;


//      var sportvis = data.modeName === "sport";
      var comfortvis = data.modeName === "comfort";

      if (comfortvis === true) {
        roots.nimb.css({opacity: 1});
        roots.rpm2.css({opacity: 1});
        roots.stat.css({opacity: 1});
        roots.comfort.css({opacity: 1});
        roots.pereg.css({opacity: 1});
        speedoDisplay.gears.P.n.classList.remove("move");
        speedoDisplay.gears.R.n.classList.remove("move");
        speedoDisplay.gears.N.n.classList.remove("move");
        speedoDisplay.gears.D.n.classList.remove("move");
        speedoDisplay.gears.S.n.classList.remove("move");
        speedoDisplay.gears.P.n.classList.add("big");
        speedoDisplay.gears.R.n.classList.add("big");
        speedoDisplay.gears.N.n.classList.add("big");
        speedoDisplay.gears.D.n.classList.add("big");
        speedoDisplay.gears.S.n.classList.add("big");


      } else {
        roots.rpm2.css({opacity: 0});
        roots.pereg.css({opacity: 0});
        roots.nimb.css({opacity: 0});
        roots.stat.css({opacity: 0});
        roots.comfort.css({opacity: 0});
        speedoDisplay.gears.P.n.classList.add("move");
        speedoDisplay.gears.R.n.classList.add("move");
        speedoDisplay.gears.N.n.classList.add("move");
        speedoDisplay.gears.D.n.classList.add("move");
        speedoDisplay.gears.S.n.classList.add("move");
        speedoDisplay.gears.P.n.classList.remove("big");
        speedoDisplay.gears.R.n.classList.remove("big");
        speedoDisplay.gears.N.n.classList.remove("big");
        speedoDisplay.gears.D.n.classList.remove("big");
        speedoDisplay.gears.S.n.classList.remove("big");


      }
//      driveMode.drivemode_text.text(data.modeName);

    }
    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        updateGearIndicator(data);
        updateTachoDisplays(data);
        updateElectrics(data);
        pmam(data);

        sidewize(data);
        widewize(data);
//        hardangle(data);

      }
    }
  });