-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local hasSentMapData = false
local vehicleID = obj:getID()
local htmlTexture = require("htmlTexture")
local naviScreenName = "@b2_c2_screen_lua"
--local gaugesScreenName = "@etk800_gauges_screen"
local gaugesScreenName = "@c2_lcd"

local timer = 1
local timersec = false
local doorsthreshold = 0.1
local doors = {}

local distance = 0
local fuel = 0

local engDIEDED = false
local radDIEDED = false
local wDIEDED = false
local hasRegisteredQuickAccess = false
local osLang = "en"

local data = {}

local dev = {}

local function runFunc(func)
	obj:queueGameEngineLua("if be:getObjectByID("..vehicleID..") then be:getObjectByID("..vehicleID.."):queueJSUITexture('"..gaugesScreenName.."', '"..func.."') end")
end

local function initDoors()
	doors["FL"]= {}
	doors["FL"]["bk"]= {"doorhinge_a_FL"}--,"doorhinge_a_FL","doorhinge_b_FL"}
	doors["FL"]["beams"]={}
	doors["FL"]["broken"]=false

	doors["RL"]= {}
	doors["RL"]["bk"]= {"doorlatch_RL"}--,"doorhinge_a_RL","doorhinge_b_RL"}
	doors["RL"]["beams"]={}
	doors["RL"]["broken"]=false

	doors["R"]= {}
	doors["R"]["bk"]= {"trunklatch_up","trunkhinge_L","trunkhinge_R","trunklatch"}
	doors["R"]["beams"]={}
	doors["R"]["broken"]=false

	doors["RR"]= {}
	doors["RR"]["bk"]= {"doorlatch_RR"}--,"doorhinge_a_RR","doorhinge_b_RR"}
	doors["RR"]["beams"]={}
	doors["RR"]["broken"]=false

	doors["FR"]= {}
	doors["FR"]["bk"]= {"doorlatch_FR"}--,"doorhinge_a_FR","doorhinge_b_FR"}
	doors["FR"]["beams"]={}
	doors["FR"]["broken"]=false

	for _,b in pairs(v.data.beams) do
		if b.breakGroup and b.breakGroup ~= "" then--and b.breakGroup == "challenger_doorlatch_FR" then

			for k,br in pairs(doors) do
				for _,bki in pairs(br["bk"]) do
					if b.breakGroup == bki then
						local ob = {}
						ob["id"]=b.cid
						ob["l"]=obj:getBeamLength(b.cid)
						table.insert(br["beams"], ob )
					end
				end
			end


			--beamdoor = b.cid
			--lendoor = obj:getBeamLength(beamdoor)
			--log('D', "C2.init",  "Beam door found "..beamdoor)
			--log('D', "C2.init",  "Beam door len= ".. lendoor .."lenREF= " ..obj:getBeamLengthRefRatio(beamdoor) .. "lenREST= "..obj:getBeamLengthRestRatio(beamdoor)  )
		end
    end
	log('D', "C2.init",  "Beam door FL ".. table.getn( doors["FL"]["beams"]) )
	log('D', "C2.init",  "Beam door RL ".. table.getn( doors["RL"]["beams"]) )
	log('D', "C2.init",  "Beam door R ".. table.getn( doors["R"]["beams"]) )
	log('D', "C2.init",  "Beam door FR ".. table.getn( doors["FR"]["beams"]) )
	log('D', "C2.init",  "Beam door RR ".. table.getn( doors["RR"]["beams"]) )
end

local function updateDoors()
	for k,d in pairs(doors) do
		if d["broken"] == false then
			for _,bd in pairs(d["beams"]) do
				local lenp = obj:getBeamLength(bd["id"])
				if lenp > (bd["l"]*doorsthreshold+bd["l"]) or lenp < (bd["l"]-bd["l"]*doorsthreshold) then
					d["broken"] = true
					log('D', "C2.updateDoors",  "door broken".. k )
					--runFunc( "updateDoors(".. tostring(doors["FL"]["broken"]) ..",0,".. tostring(doors["R"]["broken"]) ..",0,".. tostring(doors["FR"]["broken"]) ..")" )
					data = {FL = doors["FL"]["broken"], RL=doors["RL"]["broken"], R=doors["R"]["broken"], RR=doors["RR"]["broken"], FR=doors["FR"]["broken"]}
					htmlTexture.call(gaugesScreenName, "updateDoors", data)
					break
				end
			end
		end
	end
end

local function registerQuickAccess()
  if not hasRegisteredQuickAccess and core_quickAccess ~= nil then
	core_quickAccess.addEntry({ level = '/', uniqueID = 'C2folder' , title = 'Charger', icon="C2_B2_ICON.svg", goto = '/c2/'} )
	core_quickAccess.addEntry({ level = '/c2/', uniqueID = 'C2gen', priority = 10 , generator = function(entries)
    local e = { title = 'Next Info', icon="material_info", onSelect = function() htmlTexture.call(gaugesScreenName, "nextInfo", {}) return {'reload'} end }
    --if electrics.values.lights_state == 0 then e.color = '#ffa800' end
    table.insert(entries, e)

    e = { title = 'Reset', icon="material_cached", onSelect = function() htmlTexture.call(gaugesScreenName, "resetInfo", {}) return {'reload'} end }
    --if electrics.values.lights_state == 1 then e.color = '#ffa800' end
    table.insert(entries, e)
	end})
	hasRegisteredQuickAccess = true
  end
end


local function onVehicleLoaded()
    hasSentMapData = false
    htmlTexture.create(gaugesScreenName, "local://local/vehicles/challenger/gauges_screen/gauges_screen.html", 1024, 873, 15, 'automatic')

	hasSentMapData = true
	
	dev = powertrain.getDevices()

	initDoors()
	--runFunc("updateCC( false, 0)")

	registerQuickAccess()

	obj:queueGameEngineLua('be:getObjectByID(' .. obj:getID() .. '):queueLuaCommand(\'C2screens.setOsLang("\'.. tostring(Lua:getOSLanguage()) .. \'")\' )')	

end

local function updateGFX(dt)
    if hasSentMapData then
        local pos = obj:getPosition()
        local rotation = math.deg(obj:getDirection()) + 180
        local speedgps = (electrics.values.airspeed or 0) * 3.6
		local speed = (electrics.values.wheelspeed or 0) * 3.6
        local zoom = math.min(150 + speedgps * 1.5, 250)

        --obj:queueGameEngineLua("if be:getObjectByID("..vehicleID..") then be:getObjectByID("..vehicleID.."):queueJSUITexture('"..naviScreenName.."', 'map.setPosition("..pos.x..", "..pos.y..", "..rotation..")') end")
        --obj:queueGameEngineLua("if be:getObjectByID("..vehicleID..") then be:getObjectByID("..vehicleID.."):queueJSUITexture('"..naviScreenName.."', 'map.setZoom("..zoom..")') end")

		timer = timer + dt
		--runFunc("updateSpd("..speed..",".. dt ..")")
		data = {spd = speed, dt = dt, rpm = (electrics.values.rpm or 0)}
		htmlTexture.call(gaugesScreenName, "updateSpd", data)

		distance = distance + (electrics.values.wheelspeed or 0) * dt
		--print("distance"..distance .."\tspd"..(electrics.values.wheelspeed or 0) .. "\tt="..dt )
		if timer > 0.5 then
			--obj:queueGameEngineLua("be:getObjectByID("..vehicleID.."):queueJSUITexture('"..gaugesScreenName.."', 'updateData("..math.ceil(speed)..", "..drivetrain.gear..")')")
			--obj:queueGameEngineLua("if be:getObjectByID("..vehicleID..") then be:getObjectByID("..vehicleID.."):queueJSUITexture('"..gaugesScreenName.."', 'updateData("..speed..", "..drivetrain.gear..")') end")

			--runFunc("updateGear("..drivetrain.gear..",".. v.data.engine.transmissionType ..")")
			--runFunc("updateGear(".. (drivetrain.gear or 0) .. "," .. (drivetrain.shifterMode or 0) ..")")
			data = {gear = (drivetrain.gear or 0), mode = (drivetrain.shifterMode or 0) }
			htmlTexture.call(gaugesScreenName, "updateGear", data)
			--runFunc("updateFuel(".. (electrics.values.fuel or 0) ..")")
			data = {fuel = (electrics.values.fuel or 0)}
			htmlTexture.call(gaugesScreenName, "updateFuel", data)
			--lights
			timer = 0


			updateDoors()
			local unit = tostring( settings.getValue("uiUnitLength") )
			--print("Unit='" .. unit .. "' metric".. tostring(unit=="metric"))
			--runFunc("updateUnit(".. tostring( ( unit or 'metric') == "metric") ..")")
			data = {unit = ( ( unit or 'metric') == "metric") }
			--log('D', 'C2Screen', 'uiUnitLength metric? ' .. dumps(data))
			htmlTexture.call(gaugesScreenName, "updateUnit", data)

			local tEnv = obj:getEnvTemperature() --kelvin to celsius
			--runFunc('updateTemp('.. tostring(tEnv) ..', "'.. ( settings.getValue("uiUnitTemperature") or 'c') ..'")')
			--print("temp Unit = "..settings.getValue("uiUnitTemperature"))
			data = {tenv = tEnv, unit=( settings.getValue("uiUnitTemperature") or 'c'), water=(electrics.values.watertemp or 0), oil=(electrics.values.oiltemp or 0) }
			--log('D', 'C2Screen', 'uiUnitTemperature ' .. dumps(data))
			htmlTexture.call(gaugesScreenName, "updateTemp", data)

			--runFunc('updateLang( "'.. settings.getValue("userLanguage") ..'" )')
			data = {lng = settings.getValue("userLanguage"), os=osLang }
			--log('D', 'C2Screen', 'userLanguage ' .. dumps(data))
			htmlTexture.call(gaugesScreenName, "updateLang", data)

			if cruiseControl~=nil and cruiseControl.getConfiguration ~=nil then
				data = cruiseControl.getConfiguration()
				htmlTexture.call(gaugesScreenName, "updateCC", data)
			else
				data = { isEnabled = false, targetSpeed = 0, minimumSpeed = 0, hasReachedTargetSpeed = 0 }
				htmlTexture.call(gaugesScreenName, "updateCC", data)
			end
			--cruiseControl.requestState()
			--runFunc("updateCC(".. cruiseControl.isEnabled ..", ".. cruiseControl.targetSpeed ..")")

			--dev = powertrain.getDevices()
			if dev['mainEngine'] ~= nil then
				engDIEDED = dev['mainEngine'].isDisabled
				if dev['mainEngine']['thermals']['radiatorDamage'] then --pre 0.20
					radDIEDED = dev['mainEngine']['thermals']['radiatorDamage'] > 0
				else --0.20 and later
					local radIntegrity = dev['mainEngine']['thermals'].getPartConditionRadiator()
					radDIEDED = radIntegrity < 0.5
				end
			else
				engDIEDED = false
				radDIEDED = false
			end
			
			wDIEDED = false
			for i=1,#wheels.wheels,1 do
				if wheels.wheels[i].isBroken then
					wDIEDED = true
				end
			end

			if dev['wheelaxleFL'] ~= nil and dev['wheelaxleFR'] ~= nil then
				wDIEDED = wDIEDED or dev['wheelaxleFL'].isBroken or dev['wheelaxleFR'].isBroken
			end

			data = {eng = engDIEDED, rad=radDIEDED, w=wDIEDED}
			htmlTexture.call(gaugesScreenName, "updateDamage", data)


			--add electrics values for glowmap
			electrics.values.temp = (electrics.values.watertemp or 0) >= 120 or radDIEDED

			if timersec then
				--print("spd MS="..(electrics.values.wheelspeed or 0))
				--runFunc("updateConso(".. fuel .. "," .. (electrics.values.fuel or 0) .. "," .. distance .. "," .. tostring((settings.getValue("uiUnitConsumptionRate") or "metric")=="metric") ..")")
				data = {fuel=fuel, nfuel=(electrics.values.fuel or 0), dist=distance, unit=tostring((settings.getValue("uiUnitConsumptionRate") or "metric")=="metric")}
				htmlTexture.call(gaugesScreenName, "updateConso", data)

				distance = 0
				fuel = (electrics.values.fuel or 0)

				timersec = false
			else
				timersec = true
			end
			htmlTexture.call(gaugesScreenName, "removeMsg")

		end

    end
end

local function nextInfo()
   runFunc("nextInfo()")
end

local function setOsLang(l)
	log('D', "C2.setOsLang", tostring(l))
	osLang = l
end

local function onReset()
	engDIEDED = false
	radDIEDED = false
	wDIEDED = false
	-- data = {eng = engDIEDED, rad=radDIEDED, w=wDIEDED}
	htmlTexture.call(gaugesScreenName, "onReset")
	obj:queueGameEngineLua('be:getObjectByID(' .. obj:getID() .. '):queueLuaCommand(\'C2screens.setOsLang("\'.. tostring(Lua:getOSLanguage()) .. \'")\' )')	
end

-- public interface
M.onVehicleLoaded   = onVehicleLoaded
M.updateGFX = updateGFX
M.nextInfo  = nextInfo
M.setOsLang = setOsLang
M.onReset = onReset

return M
