// console.log("load gaugesScreen");
angular.module('gaugesScreen', [])

  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;

    var speedoDisplay = { };
    var infoDisplay = {};
    var electrics = {lights:{} };
    var gagues = {fuel:{},temp:{}};
    let gmeter = {};

    var speedoInitialised = true;
    var cachedVal = { temp:-100, fuel:-100, gForcesVisible: false};

    var ready = false;

    var unit = "metric";
    var unitspeedConv = 3.6;

    function updateClock(){
      let date = new Date();
      let h = date.getHours(); // 0 - 23
      let m = date.getMinutes(); // 0 - 59
      let s = date.getSeconds();
      //h = h%12 +1
      m = (m < 10)? "0"+m : m
      let timeStr = h +":"+m //+":" + s
      speedoDisplay.clockTxt.text(timeStr)
      setTimeout(updateClock, 1000);
    }

    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
      svg = $element[0].children[0].children[0];

      // speedometer
      speedoDisplay.root = hu('#layer6', svg); //label= txt
      speedoDisplay.rootspeedo = hu('#speedometer', svg); //label= txt
      speedoDisplay.speedometerText = hu('#speedometerText', speedoDisplay.rootspeedo)
      speedoDisplay.speedUnit = hu('#speedUnit', speedoDisplay.rootspeedo);
      speedoDisplay.clockTxt = hu('#clock_txt', speedoDisplay.root)
      // speedoDisplay.speedValue = hu('#speedValue', speedoDisplay.speedometerText);
      // speedoDisplay.speedValues = []
      // speedoDisplay.speedValues.push(speedoDisplay.speedValue.n.querySelector("#tspanSpdUnit") );
      // speedoDisplay.speedValues.push(speedoDisplay.speedValue.n.querySelector("#tspanSpdDizaine") );
      // speedoDisplay.speedValues.push(speedoDisplay.speedValue.n.querySelector("#tspanSpdCentaine") );
      speedoDisplay.gear = hu('#gear_txt', speedoDisplay.root);

      gagues.fuel.needle = hu('#needle_fuel', svg);
      gagues.fuel.grad = hu('#linGrad_fuel', svg);
      gagues.fuel.path = hu('#path_fuel', svg);

      gagues.temp.needle = hu('#needle_temp', svg);
      gagues.temp.grad = hu('#linGrad_temp', svg);
      gagues.temp.path = hu('#path_temp', svg);


      electrics.temp_logo = hu("#temp_logo", electrics.root);
      electrics.fuel_logo = hu("#fuel_logo", electrics.root);

      electrics.mode_txt = hu("#mode_txt", electrics.root);
      electrics.mode_txt.text("ready")

      gmeter.root = hu("#gmeter-layer",svg)
      gmeter.circle = hu("#gmeter-circle",gmeter.root)

      ready = true;
      updateClock();
      // console.log("rdy")
    }

    function limitVal(min, val,max){
        return Math.min(Math.max(min,val), max);
    }

    function updateAccelerometer(data) {
      //86
      gmeter.circle.css({transform: `translate(${limitVal(-10,data.customModules.accelerationData.xSmooth,10)*8}px, ${-limitVal(-10,data.customModules.accelerationData.ySmooth,10)*8}px`})
      // var roundedGX2 = (data.customModules.accelerationData.xSmooth / 10).toFixed(1);
      // var roundedGY2 = (-data.customModules.accelerationData.ySmooth / 10).toFixed(1);
      // infoDisplay.gXPositive.text(roundedGX2 > 0 ? roundedGX2  : 0)
      // infoDisplay.gXNegative.text(roundedGX2 < 0 ? -roundedGX2 : 0)
      // infoDisplay.gYNegative.text(roundedGY2 > 0 ? roundedGY2  : 0)
      // infoDisplay.gYPositive.text(roundedGY2 < 0 ? -roundedGY2 : 0)
    }

    function updateGagueFuel(data) {
      if (speedoInitialised) {
        data["electrics"]["fuel"]
        //cachedVal.fuel
        let pos = gagues.fuel.path.n.getPointAtLength(data["electrics"]["fuel"] * gagues.fuel.path.n.getTotalLength())
        gagues.fuel.needle.n.style.transform = "translate("+pos.x+"px, "+(pos.y+4)+"px)"
        gagues.fuel.grad.attr({y2: pos.y})
      }
    }

    function updateGagueTemp(data) {
      if (speedoInitialised) {
        let val = (data["electrics"]["watertemp"] - 50) / 80 //min 50C, max 130C
        val = limitVal(0,val,1)
        let pos = gagues.temp.path.n.getPointAtLength(val * gagues.temp.path.n.getTotalLength())
        gagues.temp.needle.n.style.transform = "translate("+pos.x+"px, "+(pos.y-2)+"px)"
        gagues.temp.grad.attr({y2: pos.y})
      }
    }


    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }

      //console.log("setup",data);
      if(data.unit == "metric"){
        speedoDisplay.speedUnit.text("KM/H");
        unitspeedConv = 3.6;
      }
      else{
        speedoDisplay.speedUnit.text("MPH");
        unitspeedConv = 2.23694;
      }

    }

    var hue = 0;

    function setElec(val, state, key){
      if( val === undefined || val === null){console.error("setElec: svg element not found", key); return;}
      if( state === undefined || state === null){console.error("setElec: state not found", key);val.n.style.display = "none"; return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
      val.n.style.display = cssState;
      //val.n.setAttribute("opacity", (state || state>0.1)?1.0:0.3)
    }

    $window.updateElectrics = (data) => {
      // for(var k in electrics.lights){
      //   setElec(electrics.lights[k], data.electrics[k], k);
      // }

      electrics.temp_logo.css({"fill":(data.electrics.watertemp > 110)?"#ef3535":"#fff"});
      electrics.fuel_logo.css({"fill":(data.electrics.lowfuel )?"#ef3535":"#fff"});

      // electrics.temp_env_txt.text((data.customModules.environmentData.temperatureEnv ).toFixed(0) + "°C");

    }

    //https://stackoverflow.com/a/56266358
    function isColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color !== "";
    }

    $window.updateMode = (data) => {
      if(!ready){
        console.log("calling updateMode while svg not fully loaded");
        setTimeout(function(){ $window.updateMode(data) }, 100);
        return;
      }
      //error checking because we can't trust people we work with
      // if(data === null
      // || data === undefined
      // || data.txt === null
      // || data.txt === undefined
      // || typeof data.txt !== "string"
      // || data.col === null
      // || data.col === undefined
      // || typeof data.col !== "string"){
      //   console.error("updateMode receive wrong arguments :", data);
      //   document.getElementById("layer_wip").style.display = "inline";
      //   document.getElementById("tspan995").innerHTML = "MODE";
      //   return;
      // }
      // if(!isColor(data.col)){
      //   console.error("This mode color is not in html format :",data.col)
      //   document.getElementById("layer_wip").style.display = "inline";
      //   document.getElementById("tspan995").innerHTML = "COL";
      //   return;
      // }

      //if you fixed without reload
      // if(document.getElementById("tspan995").innerHTML === "COL"
      // ||document.getElementById("tspan995").innerHTML === "MODE"){
      //   document.getElementById("layer_wip").style.display = "none";
      // }

      //hex color without # works in html but not in svg BECAUSE
      var s = new Option().style;
      s.color = data.col;
      data.col = s.color;

      electrics.mode_txt.text(data.txt);

      hu('#stop6', svg).css({"stop-color": data.col});

      cachedVal.gForcesVisible = data.txt.toLowerCase() != "comfort"
      if (cachedVal.gForcesVisible === true){
        speedoDisplay.rootspeedo.css({display: "none"});
        gmeter.root.css({display: "block"})
      }
      else {
        speedoDisplay.rootspeedo.css({display: "block"});
        gmeter.root.css({display: "none"})
      }
    }

    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        // console.log(data);
        //hue = (hue+.5) % 360;
        //setTheme(hue);

        // Update Gear display
        if(isNaN(data.electrics.gear) || data.electrics.gear >= 1)
          speedoDisplay.gear.text(data.electrics.gear)
        else{
          switch(data.electrics.gear){
            case -1:
              speedoDisplay.gear.text("R")
              break;
            case 0:
              speedoDisplay.gear.text("N")
              break;
            default:
              speedoDisplay.gear.text("???")
              break;
          }
        }

        // Update Speed displays
        speedoDisplay.speedometerText.text( (data.electrics.wheelspeed * unitspeedConv).toFixed())

        updateElectrics(data);
        updateGagueFuel(data);
        updateGagueTemp(data);

        if (cachedVal.gForcesVisible === true) {
          updateAccelerometer(data);
        }
      }
    }
    //ready = true;
  });